/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.AntPathMatcher;

public class WingsEnabledContext {
    public static final String PrefixEnabled = "wings.enabled";
    public static final String PrefixFeature = "wings.feature";
    private static final AntPathMatcher DotAntMatcher = new AntPathMatcher();
    private static final Map<String, Boolean> FeatureError = new LinkedHashMap<String, Boolean>();
    private static final Map<String, String> FeaturePrefix = new LinkedHashMap<String, String>();
    private static final Map<String, Boolean> FeatureEnable = new LinkedHashMap<String, Boolean>();
    private static final AtomicReference<Function<String, String>> EnabledProvider = new AtomicReference();
    private static final ConcurrentHashMap<String, Boolean> EnabledProperty = new ConcurrentHashMap();

    public static void putFeatureError(String key, Boolean value) {
        FeatureError.put(key, value);
    }

    public static void putFeaturePrefix(String key, String value) {
        FeaturePrefix.put(key, value);
    }

    public static void putFeatureEnable(String key, Boolean value) {
        FeatureEnable.put(key, value);
    }

    public static void removeFeatureError(String key) {
        FeatureError.remove(key);
    }

    public static void removeFeaturePrefix(String key) {
        FeaturePrefix.remove(key);
    }

    public static void removeFeatureEnable(String key) {
        FeatureEnable.remove(key);
    }

    public static void clearFeatureError() {
        FeatureError.clear();
    }

    public static void clearFeaturePrefix() {
        FeaturePrefix.clear();
    }

    public static void clearFeatureEnable() {
        FeatureEnable.clear();
    }

    public static LinkedHashMap<String, Boolean> copyFeatureError() {
        return new LinkedHashMap<String, Boolean>(FeatureError);
    }

    public static LinkedHashMap<String, String> copyFeaturePrefix() {
        return new LinkedHashMap<String, String>(FeaturePrefix);
    }

    public static LinkedHashMap<String, Boolean> copyFeatureEnable() {
        return new LinkedHashMap<String, Boolean>(FeatureEnable);
    }

    @NotNull
    public static String handlePrefix(@NotNull String key) {
        for (Map.Entry<String, String> en : FeaturePrefix.entrySet()) {
            if (!DotAntMatcher.match(en.getKey(), key)) continue;
            return en.getValue();
        }
        return PrefixEnabled;
    }

    @Nullable
    public static Boolean handleError(@NotNull String id) {
        for (Map.Entry<String, Boolean> en : FeatureError.entrySet()) {
            if (!DotAntMatcher.match(en.getKey(), id)) continue;
            return en.getValue() == Boolean.TRUE;
        }
        return null;
    }

    @Nullable
    public static Boolean handleFeature(@NotNull String id) {
        for (Map.Entry<String, Boolean> en : FeatureEnable.entrySet()) {
            if (!DotAntMatcher.match(en.getKey(), id)) continue;
            return en.getValue() == Boolean.TRUE;
        }
        return null;
    }

    public static void setEnabledProvider(@NotNull Function<String, String> prop) {
        EnabledProvider.set(prop);
    }

    public static void putEnabledProperty(String key, Boolean value) {
        EnabledProperty.put(key, value);
    }

    public static void removeEnabledProperty(String key) {
        EnabledProperty.remove(key);
    }

    public static void clearEnabledProperty() {
        EnabledProperty.clear();
    }

    public static HashMap<String, Boolean> copyEnabledProperty() {
        return new HashMap<String, Boolean>(EnabledProperty);
    }

    @Nullable
    public static Boolean handleEnabled(@NotNull String key) {
        Boolean bool = EnabledProperty.get(key);
        if (bool != null) {
            return bool;
        }
        Function<String, String> func = EnabledProvider.get();
        if (func == null) {
            return null;
        }
        String pp = func.apply(key);
        if ("false".equalsIgnoreCase(pp)) {
            bool = Boolean.FALSE;
        } else if ("true".equalsIgnoreCase(pp)) {
            bool = Boolean.TRUE;
        }
        if (bool != null) {
            EnabledProperty.put(key, bool);
        }
        return bool;
    }

    public static void reset() {
        WingsEnabledContext.clearFeatureError();
        WingsEnabledContext.clearFeaturePrefix();
        WingsEnabledContext.clearFeatureEnable();
        WingsEnabledContext.clearEnabledProperty();
    }
}

