/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.message;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.wings.silencer.message.CombinableMessageSource;

public class MessageSourceHelper {
    public static final MessageSource Dummy = new MessageSource(){

        public String getMessage(@NotNull String code, Object[] args, String defaultMessage, @NotNull Locale locale) {
            throw new IllegalStateException("should bind before using");
        }

        @NotNull
        public String getMessage(@NotNull String code, Object[] args, @NotNull Locale locale) throws NoSuchMessageException {
            throw new IllegalStateException("should bind before using");
        }

        @NotNull
        public String getMessage(@NotNull MessageSourceResolvable resolvable, @NotNull Locale locale) throws NoSuchMessageException {
            throw new IllegalStateException("should bind before using");
        }
    };
    public static final CombinableMessageSource Combine = new CombinableMessageSource();
    protected static volatile MessageSource Primary = Dummy;
    protected static volatile I18nAware.I18nSource i18nSource = (arg_0, arg_1, arg_2, arg_3) -> ((MessageSource)Dummy).getMessage(arg_0, arg_1, arg_2, arg_3);
    protected static volatile boolean hasPrimary = false;
    protected static volatile boolean hasCombine = false;

    public MessageSourceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageSourceHelper(@NotNull MessageSource primary) {
        Class<MessageSourceHelper> clazz = MessageSourceHelper.class;
        synchronized (MessageSourceHelper.class) {
            if (primary instanceof HierarchicalMessageSource) {
                HierarchicalMessageSource hierarchy = (HierarchicalMessageSource)primary;
                MessageSource parent = hierarchy.getParentMessageSource();
                if (parent != null) {
                    Combine.setParentMessageSource(parent);
                }
                hierarchy.setParentMessageSource((MessageSource)Combine);
                hasCombine = true;
            }
            Primary = primary;
            i18nSource = (arg_0, arg_1, arg_2, arg_3) -> ((MessageSource)primary).getMessage(arg_0, arg_1, arg_2, arg_3);
            hasPrimary = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static MessageSource Primary() {
        return Primary;
    }

    public static boolean hasPrimary() {
        return hasPrimary;
    }

    public static boolean hasCombine() {
        return hasCombine;
    }

    public static I18nAware.I18nSource i18nSource() {
        return i18nSource;
    }

    public static String getMessage(@NotNull String code, Object[] args, String defaultMessage, @NotNull Locale locale) {
        return Primary.getMessage(code, args, defaultMessage, locale);
    }

    @NotNull
    public static String getMessage(@NotNull String code, Object[] args, @NotNull Locale locale) throws NoSuchMessageException {
        return Primary.getMessage(code, args, locale);
    }

    @NotNull
    public static String getMessage(@NotNull MessageSourceResolvable resolvable, @NotNull Locale locale) throws NoSuchMessageException {
        return Primary.getMessage(resolvable, locale);
    }

    @NotNull
    public static String getMessage(@NotNull I18nAware i18nAware, @NotNull Locale locale) throws NoSuchMessageException {
        return i18nAware.toString(locale, i18nSource);
    }
}

