/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import pro.fessional.wings.silencer.runner.ApplicationReadyEventRunner;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SilencerRunnerConfiguration {
    private static final Log log = LogFactory.getLog(SilencerRunnerConfiguration.class);

    @Component
    @ConditionalWingsEnabled
    public static class StartedEvent
    implements ApplicationListener<ApplicationStartedEvent> {
        public void onApplicationEvent(@NotNull ApplicationStartedEvent event) {
            ConfigurableApplicationContext context = event.getApplicationContext();
            Map beans = context.getBeansOfType(ApplicationStartedEventRunner.class);
            if (beans.isEmpty()) {
                log.info((Object)"===>>> Silencer applicationStartedEventRunner empty");
                return;
            }
            log.info((Object)("===>>> Silencer applicationStartedEventRunner size=" + beans.size()));
            ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
            for (Map.Entry en : beans.entrySet()) {
                log.info((Object)(">>> started=" + (String)en.getKey()));
                try {
                    ((ApplicationStartedEventRunner)en.getValue()).run(args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info((Object)"===<<< Silencer applicationStartedEventRunner");
        }
    }

    @Component
    @ConditionalWingsEnabled
    public static class ReadyEvent
    implements ApplicationListener<ApplicationReadyEvent> {
        public void onApplicationEvent(@NotNull ApplicationReadyEvent event) {
            ConfigurableApplicationContext context = event.getApplicationContext();
            Map beans = context.getBeansOfType(ApplicationReadyEventRunner.class);
            if (beans.isEmpty()) {
                log.info((Object)"===>>> Silencer applicationReadyEventRunner empty");
                return;
            }
            log.info((Object)("===>>> Silencer applicationReadyEventRunner size=" + beans.size()));
            ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
            for (Map.Entry en : beans.entrySet()) {
                log.info((Object)(">>> ready=" + (String)en.getKey()));
                try {
                    ((ApplicationReadyEventRunner)en.getValue()).run(args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info((Object)"===<<< Silencer applicationReadyEventRunner");
        }
    }
}

