/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationListener;

public class DeferredLogFactory
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final ConcurrentHashMap<Class<?>, DeferredLog> logs = new ConcurrentHashMap();

    public static DeferredLog getLog(Class<?> claz) {
        return logs.computeIfAbsent(claz, k -> new DeferredLog());
    }

    public void onApplicationEvent(@NotNull ApplicationPreparedEvent event) {
        logs.forEach(Integer.MAX_VALUE, (k, v) -> v.replayTo(k));
    }
}

