/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class WingsReorderProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final Log log = LogFactory.getLog(WingsReorderProcessor.class);
    public static final String PrefixReorder = "wings.reorder";
    public static final String PrefixPrimary = "wings.primary";
    private Environment environment;

    public void setEnvironment(@NotNull Environment env) {
        this.environment = env;
    }

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map reorderProp = (Map)Binder.get((Environment)this.environment).bind(PrefixReorder, Bindable.mapOf(String.class, Integer.class)).orElseGet(Collections::emptyMap);
        Map primaryProp = (Map)Binder.get((Environment)this.environment).bind(PrefixPrimary, Bindable.mapOf(String.class, Boolean.class)).orElseGet(Collections::emptyMap);
        if (reorderProp.isEmpty() && primaryProp.isEmpty()) {
            log.info((Object)"WingsReorderProcessor skipped, for no properties under wings.reorder and wings.primary");
            return;
        }
        for (String bn : beanFactory.getBeanDefinitionNames()) {
            Boolean primary;
            BeanDefinition definition = beanFactory.getBeanDefinition(bn);
            Integer order = (Integer)reorderProp.get(bn);
            Object logExt = "";
            if (order == null) {
                String clz = definition.getBeanClassName();
                order = (Integer)reorderProp.get(clz);
                logExt = ", class=" + clz;
            }
            if (order != null) {
                log.info((Object)("WingsReorderProcessor reorder bean=" + bn + ", order=" + order + (String)logExt));
                definition.setAttribute("order", (Object)order);
            }
            if ((primary = (Boolean)primaryProp.get(bn)) == null) continue;
            log.info((Object)("WingsReorderProcessor reorder bean=" + bn + ", primary=" + primary));
            definition.setPrimary(primary.booleanValue());
        }
    }
}

