/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.function.SingletonSupplier;
import pro.fessional.mirana.best.Param;

public class ApplicationContextHelper {
    private static ConfigurableApplicationContext context;
    private static ConfigurableEnvironment environment;
    private static boolean helperPrepared;
    private static String appName;
    public static final String PropertySourceUnsupported = "__PropertySourceUnsupported__";
    public static final String PropertySourceDelimiter = ":";

    protected ApplicationContextHelper(@NotNull ConfigurableApplicationContext ctx) {
        context = Objects.requireNonNull(ctx);
        environment = Objects.requireNonNull(ctx.getEnvironment());
        helperPrepared = true;
    }

    public static boolean isPrepared() {
        return helperPrepared;
    }

    @NotNull
    public static String getApplicationName() {
        if (appName == null) {
            String app = environment.getProperty("spring.application.name");
            if (app == null || app.isEmpty()) {
                app = context.getApplicationName();
            }
            appName = app;
        }
        return appName;
    }

    @NotNull
    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    @NotNull
    public static ConfigurableEnvironment getEnvironment() {
        return environment;
    }

    public static String getProperties(String name) {
        return environment.getProperty(name);
    }

    public static <T> T getProperties(String name, Class<T> type) {
        return (T)environment.getProperty(name, type);
    }

    @NotNull
    public static Map<String, String> listProperties() {
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        Map<String, List<String>> map = ApplicationContextHelper.listPropertySource();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (List<String> st : map.values()) {
            keys.addAll(st);
        }
        for (String key : keys) {
            if (key.equals(PropertySourceUnsupported)) continue;
            prop.put(key, environment.getProperty(key));
        }
        return prop;
    }

    @NotNull
    public static Map<String, String> listPropertiesKeys() {
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> en : ApplicationContextHelper.listPropertySource().entrySet()) {
            List<String> keys = en.getValue();
            for (String key : keys) {
                prop.putIfAbsent(key, en.getKey());
            }
        }
        return prop;
    }

    @NotNull
    public static Map<String, List<String>> listPropertySource() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (PropertySource ps : environment.getPropertySources()) {
            ApplicationContextHelper.walkPropertySource("", map, ps);
        }
        List old = (List)map.remove(PropertySourceUnsupported);
        if (old != null) {
            map.put(PropertySourceUnsupported, old);
        }
        return map;
    }

    public static void walkPropertySource(String root, @Param.Out Map<String, List<String>> srcKey, PropertySource<?> src) {
        String prefix;
        if (ConfigurationPropertySources.isAttachedConfigurationPropertySource(src)) {
            return;
        }
        String string = prefix = root == null || root.isEmpty() ? "" : root + PropertySourceDelimiter;
        if (src instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)src;
            for (PropertySource ps : cps.getPropertySources()) {
                ApplicationContextHelper.walkPropertySource(prefix + ps.getName(), srcKey, ps);
            }
        } else if (src instanceof EnumerablePropertySource) {
            EnumerablePropertySource eps = (EnumerablePropertySource)src;
            for (String key : eps.getPropertyNames()) {
                srcKey.computeIfAbsent(prefix + src.getName(), ignored -> new ArrayList()).add(key);
            }
        } else {
            srcKey.computeIfAbsent(PropertySourceUnsupported, ignored -> new ArrayList()).add(prefix + src.getName() + PropertySourceDelimiter + src.getClass().getName());
        }
    }

    @NotNull
    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    @NotNull
    public static <T> T getBean(Class<T> type) {
        return (T)context.getBean(type);
    }

    @NotNull
    public static <T> ObjectProvider<T> getBeanProvider(Class<T> type) {
        return context.getBeanProvider(type);
    }

    @NotNull
    public static <T> ObjectProvider<T> getBeanProvider(ResolvableType type) {
        return context.getBeanProvider(type);
    }

    @NotNull
    public static <T> SingletonSupplier<T> getSingletonSupplier(Class<T> type) {
        return SingletonSupplier.of(() -> context.getBean(type));
    }

    @NotNull
    public static <T> SingletonSupplier<T> getSingletonSupplier(Class<T> type, Supplier<T> elze) {
        return SingletonSupplier.of(() -> context.getBeanProvider(type).getIfAvailable(elze));
    }

    @NotNull
    public static <T> SingletonSupplier<List<T>> getSingletonSupplierOfList(Class<T> type) {
        return ApplicationContextHelper.getSingletonSupplierOfList(type, Collections::emptyList);
    }

    @NotNull
    public static <T> SingletonSupplier<List<T>> getSingletonSupplierOfList(Class<T> type, Supplier<List<T>> elze) {
        return SingletonSupplier.of(() -> {
            List lst = context.getBeanProvider(type).orderedStream().toList();
            return lst.isEmpty() ? (List)elze.get() : lst;
        });
    }

    @NotNull
    public static <T> SingletonSupplier<Map<String, T>> getSingletonSupplierOfMap(Class<T> type) {
        return ApplicationContextHelper.getSingletonSupplierOfMap(type, Collections::emptyMap);
    }

    @NotNull
    public static <T> SingletonSupplier<Map<String, T>> getSingletonSupplierOfMap(Class<T> type, Supplier<Map<String, T>> elze) {
        return SingletonSupplier.of(() -> {
            Map map = context.getBeansOfType(type);
            return map.isEmpty() ? (Map)elze.get() : map;
        });
    }

    public static String getMessage(String code, Locale locale, Object ... arg) {
        return context.getMessage(code, arg, locale);
    }

    public static Resource getResource(String local) {
        return context.getResource(local);
    }

    @NotNull
    public static Resource[] getResources(String local) {
        return context.getResources(local);
    }

    static {
        helperPrepared = false;
        appName = null;
    }
}

