/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.support;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

public class MetaJsonMaker {
    @NotNull
    public List<Meta> scanMeta() throws Exception {
        return this.scanMeta("pro.fessional.wings");
    }

    @NotNull
    public List<Meta> scanMeta(final @NotNull String pkg) throws Exception {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(this, false){
            {
                super(useDefaultFilters);
                this.addIncludeFilter((mr, ignore) -> mr.getClassMetadata().getClassName().startsWith(pkg));
            }

            protected boolean isCandidateComponent(@NotNull MetadataReader ignore) {
                return true;
            }
        };
        Set beans = scanner.findCandidateComponents(pkg);
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Meta> result = new ArrayList<Meta>(beans.size());
        String cwe = ConditionalWingsEnabled.class.getName();
        String acn = AutoConfiguration.class.getName();
        String ccn = Configuration.class.getName();
        String cbn = Bean.class.getName();
        for (BeanDefinition bd : beans) {
            ScannedGenericBeanDefinition gbd;
            String name;
            if (!(bd instanceof ScannedGenericBeanDefinition) || (name = (gbd = (ScannedGenericBeanDefinition)bd).getBeanClassName()) == null || !name.startsWith(pkg)) continue;
            String pack = name.substring(0, name.lastIndexOf(46));
            Resource res = gbd.getResource();
            if (res == null || !res.isFile()) continue;
            String tmp = res.getFile().getCanonicalPath();
            String root = tmp.substring(0, tmp.indexOf("/target/classes"));
            AnnotationMetadata amd = gbd.getMetadata();
            Map caa = amd.getAnnotationAttributes(cwe, true);
            if (caa != null) {
                boolean conf = !amd.hasEnclosingClass() && (amd.hasAnnotation(acn) || amd.hasAnnotation(ccn));
                Meta wm = new Meta((String)caa.get("abs"), name, root, name, pack, (Boolean)caa.get("value"), conf);
                result.add(wm);
            }
            for (MethodMetadata md : amd.getDeclaredMethods()) {
                Map maa;
                Map ban = md.getAnnotationAttributes(cbn, true);
                if (ban == null || (maa = md.getAnnotationAttributes(cwe, true)) == null) continue;
                String mdn = name + "." + md.getMethodName();
                Meta wm = new Meta((String)maa.get("abs"), mdn, root, name, pack, (Boolean)maa.get("value"), false);
                result.add(wm);
            }
        }
        return result;
    }

    @NotNull
    public List<Proj> projMeta(@NotNull List<Meta> meta) {
        if (meta.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Proj> prjs = new LinkedHashMap<String, Proj>();
        for (Meta mt : meta) {
            Proj prj = prjs.computeIfAbsent(mt.root, Proj::new);
            prj.grp.add(mt.pkg);
            prj.meta.add(mt);
        }
        ArrayList<Proj> list = new ArrayList<Proj>(prjs.values());
        list.sort(Comparator.comparing(Proj::getRoot));
        for (Proj prj : list) {
            prj.meta.sort(Comparator.comparing(Meta::getName));
        }
        return list;
    }

    public void writeMeta(@NotNull List<Proj> proj) throws IOException {
        this.writeMeta(proj, "additional-spring-configuration-metadata.json");
    }

    public void writeMeta(@NotNull List<Proj> proj, String json) throws IOException {
        int c = 1;
        for (Proj prj : proj) {
            String file = prj.root + "/src/main/resources/META-INF/" + json;
            System.out.printf("\n%2d %s", c++, file);
            try (FileWriter fw = new FileWriter(file);){
                fw.write("{");
                fw.write("\n  \"groups\": [");
                int i = prj.grp.size() - 1;
                for (String grp : prj.grp) {
                    fw.write("\n    {\"name\": \"wings.enabled.");
                    fw.write(grp);
                    fw.write("\"}");
                    if (i-- <= 0) continue;
                    fw.write(",");
                }
                fw.write("\n  ],");
                fw.write("\n  \"properties\": [");
                i = prj.meta.size() - 1;
                Meta pre = null;
                for (Meta mt : prj.meta) {
                    if (pre != null && !mt.claz.equals(pre.claz)) {
                        if (mt.conf) {
                            fw.write(10);
                        } else if (!mt.pkg.equals(pre.pkg)) {
                            fw.write(10);
                        }
                    }
                    pre = mt;
                    if (mt.abs.isEmpty()) {
                        fw.write("\n    {\"name\": \"wings.enabled.");
                        fw.write(mt.name);
                        fw.write("\", ");
                        if (!mt.bool) {
                            fw.write("\"defaultValue\": false, ");
                        }
                        fw.write("\"type\": \"java.lang.Boolean\"}");
                    } else {
                        fw.write("\n    {\"name\": \"wings.enabled.");
                        fw.write(mt.name);
                        fw.write("\", ");
                        if (!mt.bool) {
                            fw.write("\"defaultValue\": false, ");
                        }
                        fw.write("\"type\": \"java.lang.Boolean\", \"description\": \"");
                        fw.write(mt.abs);
                        fw.write(" for short.\"}");
                    }
                    if (i-- <= 0) continue;
                    fw.write(",");
                }
                fw.write("\n  ],");
                fw.write("\n  \"hints\": []");
                fw.write("\n}");
            }
        }
    }

    public void printMeta(@NotNull List<Proj> proj) {
        this.printMeta(new PrintWriter(System.out), proj, "pro.fessional.wings.");
    }

    public void printMeta(@NotNull PrintWriter writer, @NotNull List<Proj> proj, String omit) {
        for (Proj prj : proj) {
            File tmp = new File(prj.root);
            writer.println("\n### " + tmp.getParentFile().getName() + "/" + tmp.getName());
            boolean uls = true;
            String pkg = null;
            String nms = null;
            for (Meta mt : prj.meta) {
                Object pd;
                String pg = mt.pkg;
                if (pkg == null || !pkg.equals(pg)) {
                    uls = true;
                    writer.println("\n#### " + pg.replace(omit, ""));
                }
                pkg = pg;
                Object object = pd = mt.bool ? "" : " (false)";
                if (!mt.abs.isEmpty()) {
                    pd = (String)pd + " = " + mt.abs;
                }
                String nm = mt.name.substring(pg.length() + 1);
                if (nms != null && nm.contains(nms)) {
                    writer.println("  - " + nm.substring(nms.length()) + (String)pd);
                    continue;
                }
                if (uls) {
                    writer.println();
                }
                uls = false;
                writer.println("* ." + nm + (String)pd);
                nms = nm;
            }
            writer.flush();
        }
        writer.println();
        writer.flush();
    }

    public static class Meta {
        @NotNull
        private final String abs;
        @NotNull
        private final String name;
        @NotNull
        private final String root;
        @NotNull
        private final String claz;
        @NotNull
        private final String pkg;
        private final boolean bool;
        private final boolean conf;

        @Generated
        public Meta(@NotNull String abs, @NotNull String name, @NotNull String root, @NotNull String claz, @NotNull String pkg, boolean bool, boolean conf) {
            if (abs == null) {
                throw new NullPointerException("abs is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (claz == null) {
                throw new NullPointerException("claz is marked non-null but is null");
            }
            if (pkg == null) {
                throw new NullPointerException("pkg is marked non-null but is null");
            }
            this.abs = abs;
            this.name = name;
            this.root = root;
            this.claz = claz;
            this.pkg = pkg;
            this.bool = bool;
            this.conf = conf;
        }

        @NotNull
        @Generated
        public String getAbs() {
            return this.abs;
        }

        @NotNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NotNull
        @Generated
        public String getRoot() {
            return this.root;
        }

        @NotNull
        @Generated
        public String getClaz() {
            return this.claz;
        }

        @NotNull
        @Generated
        public String getPkg() {
            return this.pkg;
        }

        @Generated
        public boolean isBool() {
            return this.bool;
        }

        @Generated
        public boolean isConf() {
            return this.conf;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBool() != other.isBool()) {
                return false;
            }
            if (this.isConf() != other.isConf()) {
                return false;
            }
            String this$abs = this.getAbs();
            String other$abs = other.getAbs();
            if (this$abs == null ? other$abs != null : !this$abs.equals(other$abs)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$root = this.getRoot();
            String other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            String this$claz = this.getClaz();
            String other$claz = other.getClaz();
            if (this$claz == null ? other$claz != null : !this$claz.equals(other$claz)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            return !(this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Meta;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBool() ? 79 : 97);
            result = result * 59 + (this.isConf() ? 79 : 97);
            String $abs = this.getAbs();
            result = result * 59 + ($abs == null ? 43 : $abs.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            String $claz = this.getClaz();
            result = result * 59 + ($claz == null ? 43 : $claz.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "MetaJsonMaker.Meta(abs=" + this.getAbs() + ", name=" + this.getName() + ", root=" + this.getRoot() + ", claz=" + this.getClaz() + ", pkg=" + this.getPkg() + ", bool=" + this.isBool() + ", conf=" + this.isConf() + ")";
        }
    }

    public static class Proj {
        private final String root;
        private final Set<String> grp = new TreeSet<String>();
        private final List<Meta> meta = new ArrayList<Meta>();

        @Generated
        public Proj(String root) {
            this.root = root;
        }

        @Generated
        public String getRoot() {
            return this.root;
        }

        @Generated
        public Set<String> getGrp() {
            return this.grp;
        }

        @Generated
        public List<Meta> getMeta() {
            return this.meta;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proj)) {
                return false;
            }
            Proj other = (Proj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$root = this.getRoot();
            String other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            Set<String> this$grp = this.getGrp();
            Set<String> other$grp = other.getGrp();
            if (this$grp == null ? other$grp != null : !((Object)this$grp).equals(other$grp)) {
                return false;
            }
            List<Meta> this$meta = this.getMeta();
            List<Meta> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Proj;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            Set<String> $grp = this.getGrp();
            result = result * 59 + ($grp == null ? 43 : ((Object)$grp).hashCode());
            List<Meta> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "MetaJsonMaker.Proj(root=" + this.getRoot() + ", grp=" + String.valueOf(this.getGrp()) + ", meta=" + String.valueOf(this.getMeta()) + ")";
        }
    }
}

