/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import pro.fessional.mirana.data.Null;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;

public class PropHelper {
    public static final String DisabledValue = "-";
    public static final String MaskingValue = "*****";

    public static boolean invalid(String str) {
        return str == null || str.isBlank() || DisabledValue.equals(str) || MaskingValue.equals(str);
    }

    public static boolean valid(String value) {
        return !PropHelper.invalid(value);
    }

    @NotNull
    public static LinkedHashSet<String> onlyValid(Collection<String> values) {
        if (values == null) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(values.size());
        for (String value : values) {
            if (!PropHelper.valid(value)) continue;
            set.add(value);
        }
        return set;
    }

    @NotNull
    public static LinkedHashMap<String, String> onlyValid(Map<String, String> values) {
        if (values == null) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(values.size());
        for (Map.Entry<String, String> en : values.entrySet()) {
            String value = en.getValue();
            if (!PropHelper.valid(value)) continue;
            map.put(en.getKey(), value);
        }
        return map;
    }

    public static void mergeToInvalid(@NotNull Map<String, String> thiz, @Nullable Map<String, String> that) {
        if (that == null || that.isEmpty()) {
            return;
        }
        if (thiz.isEmpty()) {
            thiz.putAll(that);
        } else {
            for (Map.Entry<String, String> en : thiz.entrySet()) {
                String thisVal = en.getValue();
                if (!PropHelper.invalid(thisVal)) continue;
                String thatVal = that.get(en.getKey());
                en.setValue(thatVal);
            }
        }
    }

    @Contract(value="!null->!null")
    public static String stringResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof ClassPathResource) {
            String path = ((ClassPathResource)resource).getPath();
            return "classpath:" + path;
        }
        return resource.getURL().toExternalForm();
    }

    @NotNull
    public static String prefixOptional(@NotNull String url) {
        return url.startsWith("optional:") ? url : "optional:" + url;
    }

    @Contract(value="_,!null->!null")
    public static String removeOptional(@NotNull String url, String elz) {
        boolean ok = false;
        while (url.startsWith("optional:")) {
            url = url.substring(9);
            ok = true;
        }
        return ok ? url : elz;
    }

    @NotNull
    public static String removeOptional(@NotNull String url) {
        return PropHelper.removeOptional(url, url);
    }

    @Nullable
    public static Resource resourceString(String url) {
        ConfigurableApplicationContext resourceLoader = ApplicationContextHelper.isPrepared() ? ApplicationContextHelper.getContext() : new DefaultResourceLoader();
        return PropHelper.resourceString(url, (ResourceLoader)resourceLoader);
    }

    @Nullable
    public static Resource resourceString(String url, @NotNull ResourceLoader resourceLoader) {
        if (url == null || url.isBlank()) {
            return null;
        }
        String u1 = PropHelper.removeOptional(url, null);
        if (u1 != null) {
            try {
                return resourceLoader.getResource(u1);
            }
            catch (Exception e) {
                return null;
            }
        }
        return resourceLoader.getResource(url);
    }

    @Contract(value="!null -> !null")
    public static String commaString(Object[] items) {
        return PropHelper.delimitedString(items, ",", false, false);
    }

    @Contract(value="!null -> !null")
    public static String commaString(Collection<?> items) {
        return PropHelper.delimitedString(items, ",", false, false);
    }

    @Contract(value="!null,_,_ -> !null")
    public static String commaString(Object[] items, boolean strip, boolean drop) {
        return PropHelper.delimitedString(items, ",", strip, drop);
    }

    @Contract(value="!null,_,_ -> !null")
    public static String commaString(Collection<?> items, boolean strip, boolean drop) {
        return PropHelper.delimitedString(items, ",", strip, drop);
    }

    @Contract(value="!null,_,_,_ -> !null")
    public static String delimitedString(Object[] items, String delimiter, boolean strip, boolean drop) {
        List<Object> its = items == null ? null : Arrays.asList(items);
        return PropHelper.delimitedString(its, delimiter, strip, drop);
    }

    @Contract(value="!null,_,_,_ -> !null")
    public static String delimitedString(Collection<?> items, String delimiter, boolean strip, boolean drop) {
        if (items == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        for (Object obj : items) {
            if (obj == null) {
                if (drop) continue;
                empty = false;
                sb.append(delimiter);
                continue;
            }
            String str = obj.toString();
            if (strip) {
                str = str.strip();
            }
            if (drop && PropHelper.invalid(str)) continue;
            empty = false;
            sb.append(delimiter).append(str);
        }
        return empty ? "" : sb.substring(delimiter.length());
    }

    @NotNull
    public static String[] commaArray(String commaString) {
        return PropHelper.commaArray(commaString, true, true);
    }

    @NotNull
    public static String[] commaArray(String commaString, boolean strip, boolean drop) {
        List<String> list = PropHelper.delimitedList(commaString, ",", strip, drop);
        return list.toArray(Null.StrArr);
    }

    @NotNull
    public static List<String> commaList(String commaString) {
        return PropHelper.commaList(commaString, true, true);
    }

    @NotNull
    public static List<String> commaList(String commaString, boolean strip, boolean drop) {
        return PropHelper.delimitedList(commaString, ",", strip, drop);
    }

    @NotNull
    public static List<String> delimitedList(String delimitedString, String delimiter, boolean strip, boolean drop) {
        int curIdx;
        if (delimitedString == null || delimitedString.isBlank() && drop) {
            return Collections.emptyList();
        }
        if (delimiter == null || delimiter.isEmpty()) {
            delimiter = ",";
        }
        int len = delimiter.length();
        ArrayList<String> result = new ArrayList<String>();
        int offset = 0;
        while ((curIdx = delimitedString.indexOf(delimiter, offset)) != -1) {
            PropHelper.addValue(result, delimitedString.substring(offset, curIdx), strip, drop);
            offset = curIdx + len;
        }
        if (offset <= delimitedString.length()) {
            PropHelper.addValue(result, delimitedString.substring(offset), strip, drop);
        }
        return result;
    }

    private static void addValue(List<String> result, String str, boolean strip, boolean drop) {
        if (strip) {
            str = str.strip();
        }
        if (drop && PropHelper.invalid(str)) {
            return;
        }
        result.add(str);
    }
}

