/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.support;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class SubclassGather {
    private final ResourcePatternResolver resourcePatternResolver;
    private final MetadataReaderFactory metadataReaderFactory;

    public SubclassGather(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public Map<Class<?>, Enum<?>[]> loadSubEnums(String basePackage, Class<?> ... superClass) {
        Set<Class<?>> classes = this.loadSubClass(basePackage, superClass);
        LinkedHashMap enums = new LinkedHashMap();
        try {
            for (Class<?> clz : classes) {
                if (!clz.isEnum()) continue;
                Method method = clz.getDeclaredMethod("values", new Class[0]);
                Enum[] objs = (Enum[])method.invoke(null, new Object[0]);
                enums.put(clz, objs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return enums;
    }

    public Set<Class<?>> loadSubClass(String basePackage, Class<?> ... superClass) {
        HashSet result = new HashSet();
        TypeFilter[] typeFilters = new TypeFilter[superClass.length];
        for (int i = 0; i < superClass.length; ++i) {
            typeFilters[i] = new AssignableTypeFilter(superClass[i]);
        }
        try {
            Resource[] resources;
            String path = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)basePackage) + "/**/*.class";
            for (Resource res : resources = this.resourcePatternResolver.getResources(path)) {
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(res);
                for (TypeFilter filter : typeFilters) {
                    if (!filter.match(metadataReader, this.metadataReaderFactory)) continue;
                    String className = metadataReader.getClassMetadata().getClassName();
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
                    result.add(clazz);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

