/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.support;

import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ClassUtils;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.lock.ArrayKey;

public class TypeSugar {
    public static final TypeDescriptor StringDescriptor = TypeDescriptor.valueOf(String.class);
    public static final TypeDescriptor BooleanDescriptor = TypeDescriptor.valueOf(Boolean.class);
    public static final TypeDescriptor IntegerDescriptor = TypeDescriptor.valueOf(Integer.class);
    public static final TypeDescriptor LongDescriptor = TypeDescriptor.valueOf(Long.class);
    public static final TypeDescriptor DoubleDescriptor = TypeDescriptor.valueOf(Double.class);
    public static final TypeDescriptor FloatDescriptor = TypeDescriptor.valueOf(Float.class);
    public static final TypeDescriptor BigDecimalDescriptor = TypeDescriptor.valueOf(BigDecimal.class);
    public static final TypeDescriptor LocalDateDescriptor = TypeDescriptor.valueOf(LocalDate.class);
    public static final TypeDescriptor LocalTimeDescriptor = TypeDescriptor.valueOf(LocalTime.class);
    public static final TypeDescriptor LocalDateTimeDescriptor = TypeDescriptor.valueOf(LocalDateTime.class);
    public static final TypeDescriptor ZonedDateTimeDescriptor = TypeDescriptor.valueOf(ZonedDateTime.class);
    public static final TypeDescriptor OffsetDateTimeDescriptor = TypeDescriptor.valueOf(OffsetDateTime.class);
    public static final TypeDescriptor ZoneIdDescriptor = TypeDescriptor.valueOf(ZoneId.class);
    private static final ConcurrentHashMap<Object, ResolvableType> CacheResolvable = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, TypeDescriptor> CacheDescriptor = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> ShortLong = new ConcurrentHashMap();
    private static final Pattern TypeSplit = Pattern.compile("[,<> ]+");

    @NotNull
    public static TypeDescriptor describe(@NotNull Class<?> clazz, Class<?> ... generics) {
        ArrayKey key = generics == null || generics.length == 0 ? clazz : new ArrayKey(new Object[]{clazz, generics});
        return CacheDescriptor.computeIfAbsent(key, arg_0 -> TypeSugar.lambda$describe$0((Class)clazz, generics, arg_0));
    }

    @NotNull
    public static ResolvableType resolve(@NotNull Class<?> clazz, Class<?> ... generics) {
        ArrayKey key = generics == null || generics.length == 0 ? clazz : new ArrayKey(new Object[]{clazz, generics});
        return CacheResolvable.computeIfAbsent(key, arg_0 -> TypeSugar.lambda$resolve$1((Class)clazz, generics, arg_0));
    }

    @NotNull
    public static Type type(@NotNull Class<?> clazz, Class<?> ... generics) {
        return TypeSugar.resolve(clazz, generics).getType();
    }

    @NotNull
    public static TypeDescriptor describeNew(@NotNull Class<?> clazz, Class<?> ... generics) {
        return new TypeDescriptor(TypeSugar.resolveNew(clazz, generics), null, null);
    }

    @NotNull
    public static ResolvableType resolveNew(@NotNull Class<?> clazz, Class<?> ... generics) {
        int rootCnt = clazz.getTypeParameters().length;
        if (rootCnt == 0) {
            return ResolvableType.forClass(clazz);
        }
        int paraCnt = generics == null ? 0 : generics.length;
        ResolvableType[] rootArg = new ResolvableType[rootCnt];
        if (paraCnt <= rootCnt) {
            int i;
            for (i = 0; i < paraCnt; ++i) {
                rootArg[i] = ResolvableType.forClass(generics[i]);
            }
            for (i = paraCnt; i < rootCnt; ++i) {
                rootArg[i] = ResolvableType.forClass(Object.class);
            }
        } else {
            int nextIdx = 0;
            for (int ri = 0; ri < rootCnt; ++ri) {
                Class<?> rt = generics[nextIdx++];
                int rc = rt.getTypeParameters().length;
                nextIdx = TypeSugar.resolve(rt, rootArg, ri, rc, generics, nextIdx);
            }
        }
        return ResolvableType.forClassWithGenerics(clazz, (ResolvableType[])rootArg);
    }

    public static boolean shorten(@NotNull Class<?> claz) {
        String v1 = ShortLong.putIfAbsent(claz.getSimpleName(), claz.getName());
        return v1 == null;
    }

    @NotNull
    public static String outline(@NotNull ResolvableType type) {
        return TypeSugar.outline(type, true);
    }

    @NotNull
    public static String outline(@NotNull ResolvableType type, boolean shorten) {
        String st = type.toString();
        st = st.replace("?", "Object");
        if (shorten) {
            for (Map.Entry<String, String> en : ShortLong.entrySet()) {
                st = st.replace(en.getValue(), en.getKey());
            }
        }
        return st;
    }

    @Nullable
    public static ResolvableType resolve(String structs) {
        if (structs == null) {
            return null;
        }
        return CacheResolvable.computeIfAbsent(structs, ignore -> TypeSugar.resolveNew(structs));
    }

    @Nullable
    public static ResolvableType resolveNew(String structs) {
        if (structs == null || structs.isEmpty()) {
            return null;
        }
        String[] pts = TypeSplit.split(structs.trim());
        if (pts.length == 0) {
            return null;
        }
        ArrayList<Class> clz = new ArrayList<Class>(pts.length);
        for (String str : pts) {
            Object name;
            if (str.isEmpty()) continue;
            if (str.equals("?")) {
                clz.add(Object.class);
                continue;
            }
            if (str.endsWith("[]")) {
                String sub = str.substring(0, str.length() - 2);
                name = ShortLong.getOrDefault(sub, sub) + "[]";
            } else {
                name = ShortLong.getOrDefault(str, str);
            }
            clz.add(ClassUtils.forName((String)name, null));
        }
        int size = clz.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return TypeSugar.resolve((Class)clz.get(0), new Class[0]);
        }
        Class[] ots = clz.subList(1, size).toArray(Null.ClzArr);
        return TypeSugar.resolve((Class)clz.get(0), ots);
    }

    private static int resolve(Class<?> rootClz, ResolvableType[] rootArg, int rootIdx, int paraCnt, Class<?>[] nextClz, int nextIdx) {
        if (paraCnt <= 0) {
            rootArg[rootIdx] = ResolvableType.forClass(rootClz);
        } else {
            ResolvableType[] args = new ResolvableType[paraCnt];
            for (int i = 0; i < paraCnt; ++i) {
                Class<?> root = nextClz[nextIdx++];
                int c1 = root.getTypeParameters().length;
                nextIdx = TypeSugar.resolve(root, args, i, c1, nextClz, nextIdx);
            }
            rootArg[rootIdx] = ResolvableType.forClassWithGenerics(rootClz, (ResolvableType[])args);
        }
        return nextIdx;
    }

    private static /* synthetic */ ResolvableType lambda$resolve$1(Class clazz, Class[] generics, Object ignore) {
        return TypeSugar.resolveNew(clazz, generics);
    }

    private static /* synthetic */ TypeDescriptor lambda$describe$0(Class clazz, Class[] generics, Object ignore) {
        return TypeSugar.describeNew(clazz, generics);
    }

    static {
        TypeSugar.shorten(Void.TYPE);
        TypeSugar.shorten(Boolean.TYPE);
        TypeSugar.shorten(Byte.TYPE);
        TypeSugar.shorten(Character.TYPE);
        TypeSugar.shorten(Short.TYPE);
        TypeSugar.shorten(Integer.TYPE);
        TypeSugar.shorten(Long.TYPE);
        TypeSugar.shorten(Float.TYPE);
        TypeSugar.shorten(Double.TYPE);
        TypeSugar.shorten(Void.class);
        TypeSugar.shorten(String.class);
        TypeSugar.shorten(Object.class);
        TypeSugar.shorten(Boolean.class);
        TypeSugar.shorten(Byte.class);
        TypeSugar.shorten(Character.class);
        TypeSugar.shorten(Short.class);
        TypeSugar.shorten(Integer.class);
        TypeSugar.shorten(Long.class);
        TypeSugar.shorten(Float.class);
        TypeSugar.shorten(Double.class);
        TypeSugar.shorten(BigDecimal.class);
        TypeSugar.shorten(BigInteger.class);
        TypeSugar.shorten(Date.class);
        TypeSugar.shorten(ZoneId.class);
        TypeSugar.shorten(TimeZone.class);
        TypeSugar.shorten(Locale.class);
        TypeSugar.shorten(LocalDate.class);
        TypeSugar.shorten(LocalTime.class);
        TypeSugar.shorten(LocalDateTime.class);
        TypeSugar.shorten(ZonedDateTime.class);
        TypeSugar.shorten(OffsetDateTime.class);
        TypeSugar.shorten(Instant.class);
        TypeSugar.shorten(Collection.class);
        TypeSugar.shorten(Optional.class);
        TypeSugar.shorten(List.class);
        TypeSugar.shorten(ArrayList.class);
        TypeSugar.shorten(LinkedList.class);
        TypeSugar.shorten(Map.class);
        TypeSugar.shorten(HashMap.class);
        TypeSugar.shorten(TreeMap.class);
        TypeSugar.shorten(LinkedHashMap.class);
        TypeSugar.shorten(Set.class);
        TypeSugar.shorten(HashSet.class);
        TypeSugar.shorten(TreeSet.class);
        TypeSugar.shorten(ConcurrentHashMap.class);
    }
}

