/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import pro.fessional.wings.slardar.cache.WingsCache;
import pro.fessional.wings.slardar.cache.spring.NullsCache;
import pro.fessional.wings.slardar.spring.prop.SlardarCacheProp;

public class WingsHazelcastCacheManager
extends HazelcastCacheManager
implements WingsCache.State {
    private static final Logger log = LoggerFactory.getLogger(WingsHazelcastCacheManager.class);
    private final SlardarCacheProp slardarCacheProp;
    private final ConcurrentHashMap<String, NullsCache> nullsCache = new ConcurrentHashMap();

    public WingsHazelcastCacheManager(SlardarCacheProp cacheProp, HazelcastInstance hazelcastInstance) {
        super(hazelcastInstance);
        this.slardarCacheProp = cacheProp;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        super.setHazelcastInstance(hazelcastInstance);
    }

    public Cache getCache(@NotNull String name) {
        int size = this.slardarCacheProp.getNullSize();
        if (size < 0) {
            return super.getCache(name);
        }
        return (Cache)this.nullsCache.computeIfAbsent(name, k -> new NullsCache(super.getCache(k), size, this.slardarCacheProp.getNullLive()));
    }

    @NotNull
    public Map<String, Integer> statsCacheSize() {
        Collection dst = this.getHazelcastInstance().getDistributedObjects();
        TreeMap<String, Integer> stats = new TreeMap<String, Integer>();
        for (DistributedObject distributedObject : dst) {
            if (!(distributedObject instanceof IMap)) continue;
            IMap map = (IMap)distributedObject;
            stats.put(map.getName(), map.size());
        }
        return stats;
    }

    @NotNull
    public Set<Object> statsCacheKeys(String name) {
        Collection dst = this.getHazelcastInstance().getDistributedObjects();
        for (DistributedObject distributedObject : dst) {
            IMap map;
            if (!(distributedObject instanceof IMap) || !(map = (IMap)distributedObject).getName().equals(name)) continue;
            return map.keySet();
        }
        return Collections.emptySet();
    }
}

