/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.service.lightid;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.id.LightIdProvider;
import pro.fessional.mirana.pain.TimeoutRuntimeException;
import pro.fessional.wings.slardar.service.lightid.ser.LidKey;
import pro.fessional.wings.slardar.service.lightid.ser.LidSeg;

public class HazelcastLightIdProvider
implements LightIdProvider {
    private static final Logger log = LoggerFactory.getLogger(HazelcastLightIdProvider.class);
    private final LightIdProvider.Loader loader;
    private final IMap<LidKey, LidSeg> mapper;
    private long timeout = 1000L;

    public HazelcastLightIdProvider(LightIdProvider.Loader loader, HazelcastInstance hazelcastInstance) {
        this.loader = loader;
        this.mapper = hazelcastInstance.getMap("wings:lightid");
    }

    public long next(@NotNull String name, int block) {
        return this.next(name, block, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(@NotNull String name, int block, long timeout) {
        long next;
        long throwMs = System.currentTimeMillis() + timeout;
        LidKey key = new LidKey(name, block);
        this.mapper.lock((Object)key, timeout * 2L, TimeUnit.MILLISECONDS);
        try {
            LidSeg seg = (LidSeg)this.mapper.get((Object)key);
            if (seg == null) {
                LightIdProvider.Segment sg = this.loader.require(name, block, 1, false);
                next = sg.getHead();
                long foot = sg.getFoot();
                this.mapper.put((Object)key, (Object)new LidSeg(next + 1L, foot));
            } else {
                long foot;
                next = seg.getNext();
                if (next == (foot = seg.getFoot())) {
                    LightIdProvider.Segment sg = this.loader.require(name, block, 1, false);
                    this.mapper.put((Object)key, (Object)new LidSeg(sg.getHead(), sg.getFoot()));
                } else {
                    this.mapper.put((Object)key, (Object)new LidSeg(next + 1L, foot));
                }
            }
        }
        finally {
            this.mapper.unlock((Object)key);
        }
        long now = System.currentTimeMillis();
        if (now > throwMs) {
            throw new TimeoutRuntimeException("loading timeout=" + (now - throwMs + timeout));
        }
        return next;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

