/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.hazelcast.config.JoinConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.cache.hazelcast.WingsHazelcastCacheCustomizer;
import pro.fessional.wings.slardar.spring.prop.SlardarCacheProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class HazelcastConfigConfiguration {
    private static final Log log = LogFactory.getLog(HazelcastConfigConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.hazelcast-standalone", value=false)
    public HazelcastConfigCustomizer wingsHazelcastAloneCustomizer() {
        log.info((Object)"SlardarHazelCaching spring-bean simulator hazelcastInstance standalone");
        return config -> {
            config.setClusterName("standalone-" + System.identityHashCode(config));
            config.setProperty("hazelcast.shutdownhook.enabled", "false");
            JoinConfig network = config.getNetworkConfig().getJoin();
            network.getTcpIpConfig().setEnabled(false);
            network.getMulticastConfig().setEnabled(false);
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public HazelcastConfigCustomizer wingsHazelcastCacheCustomizer(SlardarCacheProp conf) {
        log.info((Object)"SlardarHazelCaching spring-bean wingsHazelcastCacheCustomizer");
        return new WingsHazelcastCacheCustomizer(conf);
    }
}

