/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigCustomizer;
import pro.fessional.wings.slardar.cache.WingsCache;
import pro.fessional.wings.slardar.spring.prop.SlardarCacheProp;

public class WingsHazelcastCacheCustomizer
implements HazelcastConfigCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsHazelcastCacheCustomizer.class);
    private final SlardarCacheProp cacheProp;

    public void customize(Config config) {
        Map mapCnf = config.getMapConfigs();
        for (Map.Entry entry : this.cacheProp.getLevel().entrySet()) {
            SlardarCacheProp.Conf lvl = (SlardarCacheProp.Conf)entry.getValue();
            String name = WingsCache.Naming.wildcard((String)((String)entry.getKey()));
            this.checkMapConf(config, mapCnf, name, lvl.getMaxLive(), lvl.getMaxIdle(), lvl.getMaxSize());
        }
    }

    private void checkMapConf(Config config, Map<String, MapConfig> mapCnf, String name, int ttl, int tti, int max) {
        MapConfig mc = mapCnf.get(name);
        try {
            if (mc == null) {
                mc = new MapConfig(name);
                mc.setTimeToLiveSeconds(ttl);
                mc.setMaxIdleSeconds(tti);
                mc.getEvictionConfig().setSize(max);
                log.info("Wings hazelcast addMapConfig name={}, ttl={}, tti={}, size={}", new Object[]{name, ttl, tti, max});
                config.addMapConfig(mc);
            } else {
                int max0;
                int tti0;
                boolean diff = false;
                int ttl0 = mc.getTimeToLiveSeconds();
                if (ttl0 != ttl) {
                    diff = true;
                    mc.setTimeToLiveSeconds(ttl);
                    log.warn("Wings hazelcast exist TimeToLiveSeconds of name={}, from {} to {}", new Object[]{name, ttl0, ttl});
                }
                if ((tti0 = mc.getMaxIdleSeconds()) != tti) {
                    diff = true;
                    mc.setMaxIdleSeconds(tti);
                    log.warn("Wings hazelcast exist MaxIdleSeconds of name={}, from {} to {}", new Object[]{name, tti0, tti});
                }
                if ((max0 = mc.getEvictionConfig().getSize()) != max) {
                    diff = true;
                    mc.getEvictionConfig().setSize(max);
                    log.warn("Wings hazelcast default Eviction-max0 of name={}, from {} to {}", new Object[]{name, max0, max});
                }
                if (diff) {
                    log.warn("Wings hazelcast dynamically change may has conflict. \nsee https://docs.hazelcast.com/hazelcast/5.1/configuration/dynamic-config-programmatic-api");
                }
            }
        }
        catch (InvalidConfigurationException e) {
            log.error("failed to change MapConfig, name=" + name, (Throwable)e);
        }
    }

    @Generated
    public WingsHazelcastCacheCustomizer(SlardarCacheProp cacheProp) {
        this.cacheProp = cacheProp;
    }
}

