/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.event;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class HazelcastSyncPublisher
implements ApplicationEventPublisher,
MessageListener<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HazelcastSyncPublisher.class);
    private final ApplicationEventPublisher publisher;
    private final ITopic<Object> topic;
    private final UUID uuid;

    public HazelcastSyncPublisher(@NotNull HazelcastInstance instance, @NotNull ApplicationEventPublisher publisher) {
        this.publisher = publisher;
        this.topic = instance.getTopic("SlardarApplicationEvent");
        this.uuid = this.topic.addMessageListener((MessageListener)this);
    }

    public UUID getMessageListenerUuid() {
        return this.uuid;
    }

    public void publishEvent(@NotNull Object event) {
        this.topic.publish(event);
    }

    public void onMessage(Message<Object> message) {
        Object event = message.getMessageObject();
        log.debug("publish event from hazelcast topic, event={}", event);
        this.publisher.publishEvent(event);
    }
}

