/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.session;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.events.SessionCreatedEvent;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.security.DefaultUserId;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.session.WingsSessionHelper;

public class HazelcastSessionHelper
implements WingsSessionHelper,
ApplicationListener<SessionCreatedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HazelcastSessionHelper.class);
    private final SessionRepository<Session> hazelcastRepository;
    private final IMap<String, MapSession> hazelcastSessionMap;

    public HazelcastSessionHelper(SessionRepository<Session> repository, HazelcastInstance instance, String sessionMap) {
        this.hazelcastRepository = repository;
        this.hazelcastSessionMap = instance.getMap(sessionMap);
    }

    @NotNull
    public List<MapSession> findByUserId(Long userId) {
        if (DefaultUserId.asGuest((Long)userId) || this.hazelcastSessionMap == null) {
            return Collections.emptyList();
        }
        Collection ses = this.hazelcastSessionMap.values(Predicates.equal((String)"userId", (Comparable)userId));
        return new ArrayList<MapSession>(ses);
    }

    public boolean dropSession(String sessionId) {
        if (this.hazelcastRepository == null) {
            return false;
        }
        this.hazelcastRepository.deleteById(sessionId);
        return true;
    }

    public void onApplicationEvent(@NotNull SessionCreatedEvent event) {
        Session session = event.getSession();
        SecurityContext ctx = this.getSecurityContext(session);
        if (ctx == null) {
            return;
        }
        WingsUserDetails dtl = SecurityContextUtil.getUserDetails((Authentication)ctx.getAuthentication());
        if (dtl == null) {
            return;
        }
        Session backend = this.hazelcastRepository.findById(session.getId());
        if (backend == null) {
            log.warn("Could not find Session with id={} to set UserId", (Object)session.getId());
        } else {
            long userId = dtl.getUserId();
            log.debug("set Attribute UserIdKey to session, userId={}", (Object)userId);
            backend.setAttribute("userId", (Object)userId);
            this.hazelcastRepository.save(backend);
        }
    }
}

