/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.HazelcastInstance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.hazelcast.HazelcastSessionSerializer;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.session.HazelcastSessionHelper;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarHazelSessionConfiguration {
    private static final Log log = LogFactory.getLog(SlardarHazelSessionConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public SpringSessionBackedSessionRegistry<?> sessionRegistry(FindByIndexNameSessionRepository<?> repository) {
        log.info((Object)"SlardarHazelSession spring-bean sessionRegistry");
        return new SpringSessionBackedSessionRegistry(repository);
    }

    @Bean
    @ConditionalWingsEnabled
    public HazelcastSessionHelper wingsSessionHelper(FindByIndexNameSessionRepository<Session> sessionRepository, HazelcastInstance hazelcastInstance, @Value(value="${spring.session.hazelcast.map-name:spring:session:sessions}") String sessionMapName) {
        log.info((Object)"SlardarHazelSession spring-bean wingsSessionHelper");
        return new HazelcastSessionHelper((SessionRepository<Session>)sessionRepository, hazelcastInstance, sessionMapName);
    }

    @Bean
    @ConditionalWingsEnabled
    public HazelcastConfigCustomizer wingsHazelcastSessionSerializer() {
        log.info((Object)"SlardarHazelSession spring-bean wingsHazelcastSessionSerializer");
        return config -> {
            String msc = MapSession.class.getName();
            SerializationConfig serialization = config.getSerializationConfig();
            for (SerializerConfig ss : serialization.getSerializerConfigs()) {
                Class tc;
                String tcn = ss.getTypeClassName();
                if (tcn == null && (tc = ss.getTypeClass()) != null) {
                    tcn = tc.getName();
                }
                if (!msc.equals(tcn)) continue;
                log.warn((Object)("Wings hazelcast addSerializerConfig skipped, current=" + String.valueOf(ss)));
                return;
            }
            log.info((Object)"Wings hazelcast addSerializerConfig type=MapSession");
            SerializerConfig sessionSerializer = new SerializerConfig();
            sessionSerializer.setClass(HazelcastSessionSerializer.class);
            sessionSerializer.setTypeClass(MapSession.class);
            serialization.addSerializerConfig(sessionSerializer);
        };
    }
}

