/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.SpringBootAdminServerEnabledCondition;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.domain.values.StatusInfo;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import de.codecentric.boot.admin.server.web.client.BasicAuthHttpHeaderProvider;
import de.codecentric.boot.admin.server.web.servlet.AdminControllerHandlerMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.monitor.WarnMetric;
import pro.fessional.wings.slardar.monitor.report.DingTalkReport;
import pro.fessional.wings.slardar.security.pass.BasicPasswordEncoder;
import pro.fessional.wings.slardar.spring.prop.SlardarPasscoderProp;
import reactor.core.publisher.Mono;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={SpringBootAdminServerEnabledCondition.class})
public class SlardarBootAdminServerConfiguration {
    private static final Log log = LogFactory.getLog(SlardarBootAdminServerConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    @Conditional(value={SpringBootAdminServerEnabledCondition.class})
    public BeanPostProcessor bootAdminMappingOrderPostProcessor() {
        log.info((Object)"SlardarSprint spring-bean bootAdminMappingOrderPostProcessor of BootAdmin server");
        return new BeanPostProcessor(this){

            public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
                if (bean instanceof AdminControllerHandlerMapping) {
                    AdminControllerHandlerMapping ob = (AdminControllerHandlerMapping)bean;
                    ob.setOrder(-1);
                }
                return bean;
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled
    @Conditional(value={SpringBootAdminServerEnabledCondition.class})
    public AbstractStatusChangeNotifier dingTalkNotifier(InstanceRepository repository, ObjectProvider<DingTalkReport> reportProvider) {
        log.info((Object)"SlardarSprint spring-bean dingTalkNotifier of BootAdmin server");
        final DingTalkReport reporter = (DingTalkReport)reportProvider.getIfAvailable();
        AbstractStatusChangeNotifier bean = new AbstractStatusChangeNotifier(this, repository){

            @NotNull
            protected Mono<Void> doNotify(@NotNull InstanceEvent event, @NotNull Instance instance) {
                if (reporter == null) {
                    return Mono.empty();
                }
                InstanceStatusChangedEvent sev = (InstanceStatusChangedEvent)event;
                StatusInfo sts = sev.getStatusInfo();
                Map dtl = sts.getDetails();
                ArrayList<WarnMetric.Warn> warns = new ArrayList<WarnMetric.Warn>();
                for (Map.Entry en : dtl.entrySet()) {
                    WarnMetric.Warn wr = new WarnMetric.Warn();
                    wr.setType(WarnMetric.Type.Text);
                    wr.setWarn(Objects.toString(en.getValue()));
                    wr.setRule("detail");
                    wr.setKey((String)en.getKey());
                    warns.add(wr);
                }
                String title = "status " + sts.getStatus() + " from " + this.getLastStatus(event.getInstance());
                return Mono.fromRunnable(() -> reporter.report(instance.getRegistration().getName(), instance.getId().getValue(), Collections.singletonMap(title, warns)));
            }
        };
        bean.setEnabled(reporter != null);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    @Conditional(value={SpringBootAdminServerEnabledCondition.class})
    public BasicAuthHttpHeaderProvider basicAuthHttpHeadersProvider(AdminServerProperties adminProp, final SlardarPasscoderProp passProp) {
        Map serviceMap;
        String defaultPassword;
        String defaultUserName;
        log.info((Object)"SlardarSprint spring-bean basicAuthHttpHeadersProvider of BootAdmin server");
        AdminServerProperties.InstanceAuthProperties instanceAuth = adminProp.getInstanceAuth();
        if (instanceAuth.isEnabled()) {
            defaultUserName = instanceAuth.getDefaultUserName();
            defaultPassword = instanceAuth.getDefaultPassword();
            serviceMap = instanceAuth.getServiceMap();
        } else {
            defaultUserName = null;
            defaultPassword = null;
            serviceMap = Collections.emptyMap();
        }
        log.info((Object)("Wings conf BootAdmin server basicAuthHttpHeadersProvider, instanceAuth=" + instanceAuth.isEnabled()));
        return new BasicAuthHttpHeaderProvider(this, defaultUserName, defaultPassword, serviceMap){
            private final BasicPasswordEncoder encoder;
            {
                super(defaultUserName, defaultPassword, serviceMap);
                this.encoder = new BasicPasswordEncoder(passProp.getTimeDeviationMs());
            }

            @NotNull
            protected String encode(@NotNull String username, @NotNull String password) {
                String token = this.encoder.encode((CharSequence)password);
                return super.encode(username, token);
            }
        };
    }
}

