/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import pro.fessional.mirana.bits.MdHelp;
import pro.fessional.wings.silencer.runner.CommandLineRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.security.pass.DefaultPasssaltEncoder;
import pro.fessional.wings.slardar.security.pass.PasswordEncoders;
import pro.fessional.wings.slardar.spring.conf.WingsSecBeanInitConfigurer;
import pro.fessional.wings.slardar.spring.prop.SlardarPasscoderProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={SecurityConfigurer.class})
public class SlardarSecurityConfiguration {
    private static final Log log = LogFactory.getLog(SlardarSecurityConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public DelegatingPasswordEncoder passwordEncoder(SlardarPasscoderProp prop) {
        String encoder = prop.getPassEncoder();
        String decoder = prop.getPassDecoder();
        log.info((Object)("SlardarSprint spring-bean passwordEncoder, default encoder=" + encoder + ", decoder is " + decoder));
        Map encoders = PasswordEncoders.initEncoders((long)prop.getTimeDeviationMs());
        DelegatingPasswordEncoder passwordEncoder = new DelegatingPasswordEncoder(encoder, encoders);
        passwordEncoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)encoders.get(decoder));
        return passwordEncoder;
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultPasssaltEncoder passsaltEncoder(SlardarPasscoderProp prop) {
        MdHelp md;
        String encoder = prop.getSaltEncoder();
        log.info((Object)("SlardarSprint spring-bean passsaltEncoder, default encoder=" + encoder));
        if ("sha256".equalsIgnoreCase(encoder)) {
            md = MdHelp.sha256;
        } else if ("sha1".equalsIgnoreCase(encoder)) {
            md = MdHelp.sha1;
        } else if ("md5".equalsIgnoreCase(encoder)) {
            md = MdHelp.md5;
        } else {
            throw new IllegalArgumentException("nonsupport type " + encoder);
        }
        return new DefaultPasssaltEncoder(md);
    }

    @Bean
    @ConditionalWingsEnabled
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        log.info((Object)"SlardarSprint spring-bean httpSessionEventPublisher");
        return new HttpSessionEventPublisher();
    }

    @Bean
    @ConditionalWingsEnabled
    public WingsSecBeanInitConfigurer wingsSecBeanInitConfigurer(ApplicationContext context) {
        log.info((Object)"SlardarSprint spring-bean wingsSecBeanInitConfigurer");
        return new WingsSecBeanInitConfigurer(context);
    }

    @Bean
    @ConditionalWingsEnabled
    public TerminalContext.Listener localeContextHolderTerminalContextListener() {
        log.info((Object)"SlardarSprint spring-bean localeContextHolderTerminalContextListener");
        return (del, ctx) -> {
            if (!del) {
                LocaleContextHolder.setLocaleContext((LocaleContext)new SimpleTimeZoneAwareLocaleContext(ctx.getLocale(), ctx.getTimeZone()));
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public CommandLineRunnerOrdered terminalContextListenerRunner(Map<String, TerminalContext.Listener> listeners) {
        log.info((Object)"SlardarSprint spring-runs terminalContextListenerRunner");
        return new CommandLineRunnerOrdered(-10000000, ignored -> {
            for (Map.Entry en : listeners.entrySet()) {
                String name = (String)en.getKey();
                log.info((Object)("SlardarSprint spring-conf runnerTerminalContextListener, name=" + name));
                TerminalContext.registerListener((String)name, (TerminalContext.Listener)((TerminalContext.Listener)en.getValue()));
            }
        });
    }
}

