/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.conf;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationFailureHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import pro.fessional.wings.slardar.security.WingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.slardar.security.WingsAuthTypeSource;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthFilter;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthTypeParser;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthTypeSource;

public class WingsBindLoginConfigurer
extends AbstractAuthenticationFilterConfigurer<HttpSecurity, WingsBindLoginConfigurer, WingsBindAuthFilter> {
    private String loginProcessingUrl = null;
    private Collection<String> loginProcessingMethod = Collections.emptyList();
    private WingsAuthTypeSource wingsAuthTypeSource = null;
    private WingsAuthDetailsSource<?> wingsAuthDetailsSource = null;
    private Enum<?> defaultAuthType = null;
    private final Map<String, Enum<?>> authTypes = new HashMap();

    public WingsBindLoginConfigurer() {
        super((AbstractAuthenticationProcessingFilter)new WingsBindAuthFilter(), null);
        this.usernameParameter("username");
        this.passwordParameter("password");
    }

    public WingsBindLoginConfigurer loginPage(String loginPage) {
        return (WingsBindLoginConfigurer)super.loginPage(loginPage);
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer loginForward(boolean forward) {
        ((LoginUrlAuthenticationEntryPoint)this.getAuthenticationEntryPoint()).setUseForward(forward);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer usernameParameter(String usernameParameter) {
        ((WingsBindAuthFilter)this.getAuthenticationFilter()).setUsernameParameter(usernameParameter);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer passwordParameter(String passwordParameter) {
        ((WingsBindAuthFilter)this.getAuthenticationFilter()).setPasswordParameter(passwordParameter);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer failureForwardUrl(String forwardUrl) {
        this.failureHandler((AuthenticationFailureHandler)new ForwardAuthenticationFailureHandler(forwardUrl));
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer successForwardUrl(String forwardUrl) {
        this.successHandler((AuthenticationSuccessHandler)new ForwardAuthenticationSuccessHandler(forwardUrl));
        return this;
    }

    @Contract(value="_,_->this")
    public WingsBindLoginConfigurer bindAuthTypeToEnums(String type, Enum<?> authType) {
        this.authTypes.put(type, authType);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer bindAuthTypeToEnums(Map<String, Enum<?>> authType) {
        this.authTypes.putAll(authType);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer bindAuthTypeDefault(Enum<?> authType) {
        this.defaultAuthType = authType;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer bindAuthTypeSource(WingsAuthTypeSource wingsAuthTypeSource) {
        this.wingsAuthTypeSource = wingsAuthTypeSource;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindLoginConfigurer bindAuthDetailsSource(WingsAuthDetailsSource<?> wingsAuthDetailsSource) {
        this.wingsAuthDetailsSource = wingsAuthDetailsSource;
        return this;
    }

    public WingsBindLoginConfigurer loginProcessingUrl(String loginProcessingUrl) {
        return this.loginProcessingUrl(loginProcessingUrl, Collections.singleton("POST"));
    }

    public WingsBindLoginConfigurer loginProcessingUrl(String loginProcessingUrl, Collection<String> method) {
        this.loginProcessingUrl = loginProcessingUrl;
        this.loginProcessingMethod = method;
        return (WingsBindLoginConfigurer)super.loginProcessingUrl(loginProcessingUrl);
    }

    protected RequestMatcher createLoginProcessingUrlMatcher(final String loginProcessingUrl) {
        if (this.loginProcessingMethod == null || this.loginProcessingMethod.isEmpty()) {
            return new AntPathRequestMatcher(loginProcessingUrl);
        }
        if (this.loginProcessingMethod.size() == 1) {
            return new AntPathRequestMatcher(loginProcessingUrl, this.loginProcessingMethod.iterator().next());
        }
        return new RequestMatcher(){
            private final AntPathRequestMatcher matcher;
            private final Set<String> methods;
            {
                this.matcher = new AntPathRequestMatcher(loginProcessingUrl);
                this.methods = new HashSet<String>(WingsBindLoginConfigurer.this.loginProcessingMethod);
            }

            public boolean matches(HttpServletRequest request) {
                boolean matches = this.matcher.matches(request);
                if (!matches) {
                    return false;
                }
                String method = request.getMethod();
                for (String s : this.methods) {
                    if (!s.equalsIgnoreCase(method)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void init(HttpSecurity http) throws Exception {
        super.init((HttpSecurityBuilder)http);
        this.initDefaultLoginFilter(http);
        ApplicationContext context = (ApplicationContext)((HttpSecurity)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return;
        }
        this.initBindAuthTypeSource(context);
    }

    public LoginUrlAuthenticationEntryPoint getLoginUrlAuthenticationEntryPoint() {
        return (LoginUrlAuthenticationEntryPoint)this.getAuthenticationEntryPoint();
    }

    private void initBindAuthTypeSource(ApplicationContext context) {
        WingsAuthTypeParser parser = null;
        if (this.wingsAuthTypeSource == null) {
            if (this.authTypes.isEmpty()) {
                this.wingsAuthTypeSource = (WingsAuthTypeSource)context.getBeanProvider(WingsAuthTypeSource.class).getIfAvailable();
            } else {
                if (this.defaultAuthType == null && this.authTypes.size() == 1) {
                    this.defaultAuthType = this.authTypes.values().iterator().next();
                }
                parser = new DefaultWingsAuthTypeParser(this.defaultAuthType, this.authTypes);
            }
        }
        if (this.wingsAuthTypeSource == null) {
            if (parser == null) {
                parser = (WingsAuthTypeParser)context.getBeanProvider(WingsAuthTypeParser.class).getIfAvailable();
            }
            if (parser != null) {
                this.wingsAuthTypeSource = new DefaultWingsAuthTypeSource(this.loginProcessingUrl, parser);
            }
        }
        if (this.wingsAuthTypeSource != null) {
            ((WingsBindAuthFilter)this.getAuthenticationFilter()).setWingsBindAuthTypeSource(this.wingsAuthTypeSource);
        }
        if (this.wingsAuthDetailsSource == null) {
            this.wingsAuthDetailsSource = (WingsAuthDetailsSource)context.getBeanProvider(WingsAuthDetailsSource.class).getIfAvailable();
        }
        if (this.wingsAuthDetailsSource != null) {
            ((WingsBindAuthFilter)this.getAuthenticationFilter()).setAuthenticationDetailsSource(this.wingsAuthDetailsSource);
        }
    }

    private void initDefaultLoginFilter(HttpSecurity http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = (DefaultLoginPageGeneratingFilter)http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null && !this.isCustomLoginPage()) {
            loginPageGeneratingFilter.setFormLoginEnabled(true);
            loginPageGeneratingFilter.setUsernameParameter(((WingsBindAuthFilter)this.getAuthenticationFilter()).getUsernameParameter());
            loginPageGeneratingFilter.setPasswordParameter(((WingsBindAuthFilter)this.getAuthenticationFilter()).getPasswordParameter());
            loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
            loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
            loginPageGeneratingFilter.setAuthenticationUrl(this.getLoginProcessingUrl());
        }
    }
}

