/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.conf;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import pro.fessional.wings.slardar.spring.help.SecurityConfigHelper;

public class WingsHttpPermitConfigurer
extends AbstractHttpConfigurer<WingsHttpPermitConfigurer, HttpSecurity> {
    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitCorsAll() {
        ((HttpSecurity)this.getBuilder()).cors(conf -> conf.configurationSource(SecurityConfigHelper.corsPermitAll()));
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitLogin() {
        this.requestMatchers(SecurityConfigHelper.loginAntPaths()).permitAll();
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitOAuth2() {
        this.requestMatchers(SecurityConfigHelper.oauth2AntPaths()).permitAll();
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitSwagger() {
        this.requestMatchers(SecurityConfigHelper.swaggerAntPaths()).permitAll();
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitTest() {
        this.requestMatchers(SecurityConfigHelper.testAntPaths()).permitAll();
        return this;
    }

    @NotNull
    public AuthorizeHttpRequestsConfigurer.AuthorizedUrl requestMatchers(String ... paths) {
        HttpSecurity http = (HttpSecurity)this.getBuilder();
        return (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(paths);
    }
}

