/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.conf;

import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import pro.fessional.wings.slardar.security.PasssaltEncoder;
import pro.fessional.wings.slardar.security.WingsAuthCheckService;
import pro.fessional.wings.slardar.security.WingsUserDetailsService;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthProvider;

@Order(value=-90000000)
public class WingsSecBeanInitConfigurer
extends GlobalAuthenticationConfigurerAdapter {
    public static final int ORDER = -90000000;
    private final ApplicationContext context;

    public WingsSecBeanInitConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply((SecurityConfigurer)new InitializeUserDetailsManagerConfigurer());
    }

    class InitializeUserDetailsManagerConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        InitializeUserDetailsManagerConfigurer() {
        }

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                return;
            }
            WingsUserDetailsService userDetailsService = this.getBeanOrNull(WingsUserDetailsService.class);
            if (userDetailsService == null) {
                return;
            }
            PasssaltEncoder passsaltEncoder = this.getBeanOrNull(PasssaltEncoder.class);
            PasswordEncoder passwordEncoder = this.getBeanOrNull(PasswordEncoder.class);
            UserDetailsPasswordService passwordManager = this.getBeanOrNull(UserDetailsPasswordService.class);
            WingsAuthCheckService wingsAuthCheckService = this.getBeanOrNull(WingsAuthCheckService.class);
            WingsBindAuthProvider provider = new WingsBindAuthProvider((UserDetailsService)userDetailsService);
            if (passsaltEncoder != null) {
                provider.setPasssaltEncoder(passsaltEncoder);
            }
            if (passwordEncoder != null) {
                provider.setPasswordEncoder(passwordEncoder);
            }
            if (passwordManager != null) {
                provider.setUserDetailsPasswordService(passwordManager);
            }
            if (wingsAuthCheckService != null) {
                provider.setWingsAuthCheckService(wingsAuthCheckService);
            }
            provider.afterPropertiesSet();
            auth.authenticationProvider((AuthenticationProvider)provider);
        }

        private <T> T getBeanOrNull(Class<T> type) {
            String[] beanNames = WingsSecBeanInitConfigurer.this.context.getBeanNamesForType(type);
            if (beanNames.length != 1) {
                return null;
            }
            return (T)WingsSecBeanInitConfigurer.this.context.getBean(beanNames[0], type);
        }
    }
}

