/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.actuator.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import pro.fessional.wings.slardar.cache.WingsCache;

@Endpoint(id="wingscache")
public class SlardarCacheEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlardarCacheEndpoint.class);
    private final Map<String, CacheManager> cacheManagers = new HashMap<String, CacheManager>();

    public SlardarCacheEndpoint(Map<String, CacheManager> cm) {
        for (Map.Entry<String, CacheManager> en : cm.entrySet()) {
            CacheManager v = en.getValue();
            String k = en.getKey();
            if (v instanceof WingsCache.State) {
                this.cacheManagers.put(k, v);
                log.info("init CacheManager with State, bean=" + k);
                continue;
            }
            log.info("skip CacheManager without State, bean=" + k);
        }
    }

    @ReadOperation
    public Set<String> listManager() {
        return this.cacheManagers.keySet();
    }

    @ReadOperation
    public Set<String> listCacheSize(@Selector String manager) {
        WingsCache.State cm = (WingsCache.State)this.cacheManagers.get(manager);
        if (cm != null) {
            Map set = cm.statsCacheSize();
            TreeSet<String> rs = new TreeSet<String>();
            for (Map.Entry en : set.entrySet()) {
                rs.add((String)en.getKey() + ":" + String.valueOf(en.getValue()));
            }
            return rs;
        }
        return Collections.emptySet();
    }

    @ReadOperation
    public Set<String> listCacheKeys(@Selector String manager, @Selector String cache) {
        WingsCache.State cm = (WingsCache.State)this.cacheManagers.get(manager);
        if (cm != null) {
            Set set = cm.statsCacheKeys(cache);
            TreeSet<String> rs = new TreeSet<String>();
            for (Object k : set) {
                rs.add(System.identityHashCode(k) + ":" + k.toString());
            }
            return rs;
        }
        return Collections.emptySet();
    }

    @DeleteOperation
    public String evictCacheKey(@Selector String manager, @Selector String cache, String id) {
        CacheManager cm = this.cacheManagers.get(manager);
        if (cm == null) {
            return "manager not found";
        }
        Cache cc = cm.getCache(cache);
        if (cc == null) {
            return "cache not found";
        }
        WingsCache.State st = (WingsCache.State)cm;
        Set set = st.statsCacheKeys(cache);
        int ki = Integer.parseInt(id);
        for (Object k : set) {
            if (System.identityHashCode(k) != ki) continue;
            cc.evict(k);
            return "key evict";
        }
        return "key not found";
    }
}

