/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.help;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import pro.fessional.wings.slardar.security.WingsUserDetailsService;
import pro.fessional.wings.slardar.servlet.request.FakeHttpServletRequest;
import pro.fessional.wings.slardar.spring.conf.WingsBindAuthnConfigurer;

public class SecurityConfigHelper {
    @NotNull
    public static WingsBindAuthnConfigurer<WingsUserDetailsService> auth() {
        return new WingsBindAuthnConfigurer<WingsUserDetailsService>();
    }

    @NotNull
    public static String encodePathPattern(@NotNull String path) {
        path = URLEncoder.encode(path, StandardCharsets.UTF_8);
        path = path.replace("%2F", "/");
        return path;
    }

    @NotNull
    public static FakeHttpServletRequest fakeMatcherRequest(@NotNull String path) {
        path = SecurityConfigHelper.encodePathPattern(path);
        FakeHttpServletRequest request = new FakeHttpServletRequest();
        request.setPathInfo(path);
        request.setRequestURI(path);
        return request;
    }

    @NotNull
    public static FakeHttpServletRequest fakeMatcherRequest(@NotNull String path, String servletName) {
        path = SecurityConfigHelper.encodePathPattern(path);
        FakeHttpServletRequest request = new FakeHttpServletRequest();
        request.setPathInfo(path);
        request.setRequestURI(path);
        if (servletName != null) {
            request.getHttpServletMapping().setServletName(servletName);
        }
        return request;
    }

    @NotNull
    public static CorsConfigurationSource corsPermitAll() {
        return request -> {
            CorsConfiguration conf = new CorsConfiguration();
            conf.addAllowedHeader("*");
            conf.addAllowedOrigin("*");
            conf.addAllowedMethod("*");
            conf.setMaxAge(Long.valueOf(1800L));
            return conf;
        };
    }

    @NotNull
    public static String[] oauth2AntPaths() {
        return new String[]{"/oauth/**", "/error"};
    }

    @NotNull
    public static String[] testAntPaths() {
        return new String[]{"/test/**"};
    }

    @NotNull
    public static String[] loginAntPaths() {
        return new String[]{"/login", "/login/**", "/logout"};
    }

    @NotNull
    public static String[] swaggerAntPaths() {
        return new String[]{"/swagger*/**", "/webjars/**"};
    }

    public static void prefixMvc(String mvc, String[] path) {
        if (mvc == null || mvc.isBlank()) {
            return;
        }
        if (mvc.endsWith("/")) {
            mvc = mvc.substring(0, mvc.lastIndexOf(47));
        }
        for (int i = 0; i < path.length; ++i) {
            path[i] = mvc + path[i];
        }
    }

    public static class MatcherHelper
    extends AbstractRequestMatcherRegistry<MatcherHelper> {
        private final Consumer<List<RequestMatcher>> matchersConsumer;

        public MatcherHelper(ApplicationContext context, Consumer<List<RequestMatcher>> matchersConsumer) {
            this.matchersConsumer = matchersConsumer;
            this.setApplicationContext(context);
        }

        protected MatcherHelper chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.matchersConsumer.accept(requestMatchers);
            return this;
        }

        public static MatcherHelper of(ApplicationContext context, AtomicReference<RequestMatcher> ref) {
            return new MatcherHelper(context, it -> ref.set((RequestMatcher)it.get(0)));
        }

        public static MatcherHelper of(ApplicationContext context, RequestMatcher[] ref) {
            return new MatcherHelper(context, it -> it.toArray(ref));
        }
    }
}

