/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import de.codecentric.boot.admin.client.config.ClientProperties;
import de.codecentric.boot.admin.client.config.SpringBootAdminClientEnabledCondition;
import de.codecentric.boot.admin.client.registration.BlockingRegistrationClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={SpringBootAdminClientEnabledCondition.class})
public class SlardarBootAdminClientConfiguration {
    private static final Log log = LogFactory.getLog(SlardarBootAdminClientConfiguration.class);

    @Bean
    @Conditional(value={SpringBootAdminClientEnabledCondition.class})
    @ConditionalWingsEnabled
    public BlockingRegistrationClient registrationClient(RestTemplateBuilder builder, ClientProperties prop) {
        log.info((Object)"SlardarSprint spring-bean registrationClient of BootAdmin client");
        builder = builder.setConnectTimeout(prop.getConnectTimeout()).setReadTimeout(prop.getReadTimeout());
        if (prop.getUsername() != null && prop.getPassword() != null) {
            builder = builder.basicAuthentication(prop.getUsername(), prop.getPassword());
        }
        return new BlockingRegistrationClient(builder.build());
    }
}

