/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.conf;

import org.jetbrains.annotations.Contract;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.UserDetailsAwareConfigurer;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import pro.fessional.wings.slardar.security.WingsAuthCheckService;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthProvider;

public class WingsBindAuthnConfigurer<U extends UserDetailsService>
extends UserDetailsAwareConfigurer<AuthenticationManagerBuilder, U> {
    private U userDetailsService;
    private PasswordEncoder passwordEncoder;
    private UserDetailsPasswordService userDetailsPasswordService;
    private WingsAuthCheckService wingsAuthCheckService;
    private boolean wingsBindAuthnProvider = true;

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> userDetailsService(U userDetailsService) {
        this.userDetailsService = userDetailsService;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> passwordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> userDetailsPasswordManager(UserDetailsPasswordService passwordManager) {
        this.userDetailsPasswordService = passwordManager;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> wingsBindAuthnProvider(boolean bool) {
        this.wingsBindAuthnProvider = bool;
        return this;
    }

    @Contract(value="_->this")
    public WingsBindAuthnConfigurer<U> wingsAuthCheckService(WingsAuthCheckService wingsAuthCheckService) {
        this.wingsAuthCheckService = wingsAuthCheckService;
        return this;
    }

    public void configure(AuthenticationManagerBuilder builder) {
        if (!this.wingsBindAuthnProvider) {
            return;
        }
        WingsBindAuthProvider provider = new WingsBindAuthProvider(this.userDetailsService);
        if (this.passwordEncoder != null) {
            provider.setPasswordEncoder(this.passwordEncoder);
        }
        if (this.userDetailsPasswordService != null) {
            provider.setUserDetailsPasswordService(this.userDetailsPasswordService);
        }
        if (this.wingsAuthCheckService != null) {
            provider.setWingsAuthCheckService(this.wingsAuthCheckService);
        }
        provider = (WingsBindAuthProvider)this.postProcess(provider);
        builder.authenticationProvider((AuthenticationProvider)provider);
    }

    public U getUserDetailsService() {
        return this.userDetailsService;
    }
}

