/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.conf;

import org.jetbrains.annotations.Contract;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import pro.fessional.wings.slardar.spring.help.SecurityConfigHelper;

public class WingsHttpPermitConfigurer
extends AbstractHttpConfigurer<WingsHttpPermitConfigurer, HttpSecurity> {
    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitCorsAll() {
        ((HttpSecurity)this.getBuilder()).cors(conf -> conf.configurationSource(SecurityConfigHelper.corsPermitAll()));
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitLogin() {
        ((HttpSecurity)this.getBuilder()).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(SecurityConfigHelper.loginAntPaths())).permitAll());
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitOAuth2() {
        ((HttpSecurity)this.getBuilder()).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(SecurityConfigHelper.oauth2AntPaths())).permitAll());
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitSwagger() {
        ((HttpSecurity)this.getBuilder()).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(SecurityConfigHelper.swaggerAntPaths())).permitAll());
        return this;
    }

    @Contract(value="->this")
    public WingsHttpPermitConfigurer permitTest() {
        ((HttpSecurity)this.getBuilder()).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(SecurityConfigHelper.testAntPaths())).permitAll());
        return this;
    }
}

