/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.concur.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import pro.fessional.mirana.bits.Md5;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.concur.Debounce;
import pro.fessional.wings.slardar.servlet.request.RequestHelper;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamResponseWrapper;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;

public class DebounceInterceptor
implements AutoRegisterInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DebounceInterceptor.class);
    public static final int ORDER = -29998000;
    public static final String DebounceKey = DebounceInterceptor.class.getName() + "::DebounceKey";
    private final AtomicLong seq = new AtomicLong(0L);
    private final Cache<String, Dto> cache;
    private final ModelAndView modelAndView;
    private int order = -29998000;

    public DebounceInterceptor(int capacity, int maxWait, ModelAndView res) {
        this.cache = WingsCache2k.builder(DebounceInterceptor.class, (String)"cache", (int)capacity, (int)maxWait, (int)0, String.class, Dto.class).build();
        this.modelAndView = res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        long lft;
        Dto dto;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Debounce anno = method.getAnnotation(Debounce.class);
        if (anno == null) {
            return true;
        }
        String key = this.genKey(request, anno);
        request.setAttribute(DebounceKey, (Object)key);
        long bgn = ThreadNow.millis();
        long cur = this.seq.getAndIncrement();
        Cache<String, Dto> cache = this.cache;
        synchronized (cache) {
            Dto d = (Dto)this.cache.get((Object)key);
            if (d == null || d.ttl < bgn) {
                d = new Dto(bgn + anno.waiting(), cur, anno.reuse());
                this.cache.put((Object)key, (Object)d);
            }
            dto = d;
        }
        if (dto.seq == cur) {
            if (dto.ruz) {
                ReuseStreamResponseWrapper inf = ReuseStreamResponseWrapper.infer((ServletResponse)response);
                if (inf == null) {
                    throw new IllegalStateException("NEED ReuseStreamResponseWrapper active");
                }
                inf.cachingOutputStream(false);
            }
            return true;
        }
        if (dto.ruz && (lft = dto.ttl - bgn) > 0L) {
            Dto dto2 = dto;
            synchronized (dto2) {
                try {
                    dto.wait(lft);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (dto.bds != null) {
            try {
                response.getOutputStream().write(dto.bds);
            }
            catch (IOException e) {
                log.warn("failed to reuse response", (Throwable)e);
            }
            return false;
        }
        ResponseHelper.renderModelAndView(this.modelAndView, response, request);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) {
        if (ex != null) {
            return;
        }
        String key = (String)request.getAttribute(DebounceKey);
        if (key == null) {
            return;
        }
        Dto dto = (Dto)this.cache.get((Object)key);
        if (dto == null || !dto.ruz) {
            return;
        }
        ReuseStreamResponseWrapper inf = ReuseStreamResponseWrapper.infer((ServletResponse)response);
        if (inf != null) {
            dto.bds = inf.getContentAsByteArray();
        }
        Dto dto2 = dto;
        synchronized (dto2) {
            dto.notifyAll();
        }
    }

    private String genKey(@NotNull HttpServletRequest request, Debounce anno) {
        String[] session;
        StringBuilder sum = new StringBuilder(1024);
        if (anno.session() && (session = request.getSession(false)) != null) {
            sum.append("\ns=").append(session.getId());
        }
        if (anno.method()) {
            sum.append("\nm=").append(request.getMethod());
        }
        if (anno.query()) {
            sum.append("\nq=").append(request.getQueryString());
        }
        for (String hd : anno.header()) {
            sum.append("\nh-").append(hd).append("=").append(request.getHeader(hd));
        }
        if (anno.body()) {
            InputStream ins = RequestHelper.tryCircleInputStream((ServletRequest)request);
            if (ins != null) {
                sum.append("\nb=").append(Md5.sum((InputStream)ins));
            } else {
                sum.append("\nb=").append(request.getContentLengthLong());
            }
        }
        return request.getRequestURI() + Md5.sum((String)sum.toString());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class Dto {
        private final long ttl;
        private final long seq;
        private final boolean ruz;
        private byte[] bds;

        public Dto(long ttl, long seq, boolean ruz) {
            this.ttl = ttl;
            this.seq = seq;
            this.ruz = ruz;
        }
    }
}

