/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;

public class TerminalInterceptor
implements AutoRegisterInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TerminalInterceptor.class);
    public static final int ORDER = -29995000;
    private final List<TerminalBuilder> terminalBuilders = new ArrayList<TerminalBuilder>();
    private final List<TerminalLogger> terminalLoggers = new ArrayList<TerminalLogger>();
    private int order = -29995000;
    @NotNull
    private List<String> excludePatterns = Collections.emptyList();

    public void addTerminalBuilder(TerminalBuilder builder) {
        if (builder != null) {
            this.terminalBuilders.add(builder);
        }
    }

    public void addTerminalLogger(TerminalLogger logger) {
        if (logger != null) {
            this.terminalLoggers.add(logger);
        }
    }

    @NotNull
    public TerminalContext.Context loginTerminal(@NotNull HttpServletRequest request) {
        try {
            TerminalContext.Builder builder = new TerminalContext.Builder();
            for (TerminalBuilder build : this.terminalBuilders) {
                build.build(builder, request);
            }
            if (request.getAttribute("WINGS.ATTR.TERMINAL_LOGIN") == Boolean.TRUE) {
                log.warn("should NOT loginTerminal more than once");
            } else {
                request.setAttribute("WINGS.ATTR.TERMINAL_LOGIN", (Object)Boolean.TRUE);
            }
            TerminalContext.Context ctx = builder.build();
            TerminalContext.login((TerminalContext.Context)ctx);
            return ctx;
        }
        catch (RuntimeException e) {
            log.error("should NOT be here", (Throwable)e);
            TerminalContext.logout();
            throw e;
        }
    }

    @Nullable
    public TerminalContext.Context logoutTerminal(@NotNull HttpServletRequest request) {
        if (request.getAttribute("WINGS.ATTR.TERMINAL_LOGIN") == Boolean.TRUE) {
            TerminalContext.Context ctx = TerminalContext.logout();
            request.removeAttribute("WINGS.ATTR.TERMINAL_LOGIN");
            return ctx;
        }
        return null;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        TerminalContext.Context ctx = this.loginTerminal(request);
        for (TerminalLogger log : this.terminalLoggers) {
            try {
                log.log(true, ctx, request, response, null);
            }
            catch (Exception e) {
                DummyBlock.ignore((Throwable)e);
            }
        }
        return true;
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) {
        TerminalContext.Context ctx = this.logoutTerminal(request);
        for (TerminalLogger log : this.terminalLoggers) {
            try {
                log.log(false, ctx, request, response, ex);
            }
            catch (Exception e) {
                DummyBlock.ignore((Throwable)e);
            }
        }
    }

    public List<TerminalBuilder> getTerminalBuilders() {
        return this.terminalBuilders;
    }

    public List<TerminalLogger> getTerminalLoggers() {
        return this.terminalLoggers;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setExcludePatterns(@NotNull List<String> excludePatterns) {
        if (excludePatterns == null) {
            throw new NullPointerException("excludePatterns is marked non-null but is null");
        }
        this.excludePatterns = excludePatterns;
    }

    public static interface TerminalBuilder {
        public void build(@NotNull TerminalContext.Builder var1, @NotNull HttpServletRequest var2);
    }

    public static interface TerminalLogger {
        public void log(boolean var1, @Nullable TerminalContext.Context var2, @NotNull HttpServletRequest var3, @NotNull HttpServletResponse var4, @Nullable Exception var5);
    }
}

