/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.LocaleResolver;
import pro.fessional.mirana.func.Dcl;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.WingsAuthHelper;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthDetails;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;

public class ComboWingsAuthDetailsSource
implements WingsAuthDetailsSource<WingsAuthDetails> {
    protected final List<Combo<?>> combos = new ArrayList();
    protected final Dcl<Void> dclCombos = Dcl.of(() -> this.combos.sort(Comparator.comparingInt(Ordered::getOrder)));
    protected Set<String> ignoredMetaKey = Collections.emptySet();
    protected WingsRemoteResolver wingsRemoteResolver = null;
    protected LocaleResolver localeResolver;

    @Override
    public WingsAuthDetails buildDetails(@NotNull Enum<?> authType, @NotNull HttpServletRequest request) {
        Combo<?> cb;
        this.dclCombos.runIfDirty();
        if (this.localeResolver != null) {
            Locale locale = this.localeResolver.resolveLocale(request);
            LocaleContextHolder.setLocale((Locale)locale);
        }
        DefaultWingsAuthDetails detail = null;
        Iterator<Combo<?>> iterator = this.combos.iterator();
        while (iterator.hasNext() && (detail = (cb = iterator.next()).buildDetails(authType, request)) == null) {
        }
        if (detail == null) {
            detail = new DefaultWingsAuthDetails();
        }
        this.buildMetaData(authType, request, detail);
        return detail;
    }

    public final void add(Combo<?> source) {
        if (source == null) {
            return;
        }
        this.combos.add(source);
        this.dclCombos.setDirty();
    }

    public final void addAll(Collection<? extends Combo<?>> source) {
        if (source == null) {
            return;
        }
        this.combos.addAll(source);
        this.dclCombos.setDirty();
    }

    protected void buildMetaData(@NotNull Enum<?> authType, @NotNull HttpServletRequest request, @NotNull WingsAuthDetails details) {
        Map<String, String> meta = details.getMetaData();
        String zone = WingsAuthHelper.getAuthZoneAttribute(request);
        meta.put("authType", authType.name());
        if (zone != null) {
            meta.putIfAbsent("authZone", zone);
        }
        if (this.wingsRemoteResolver != null) {
            meta.put("AuthAddr", this.wingsRemoteResolver.resolveRemoteIp(request));
            meta.put("AuthAgent", this.wingsRemoteResolver.resolveAgentInfo(request));
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String n = (String)names.nextElement();
            if (this.ignoredMetaKey.contains(n)) continue;
            meta.putIfAbsent(n, request.getParameter(n));
        }
    }

    public void setIgnoredMetaKey(Set<String> ignoredMetaKey) {
        this.ignoredMetaKey = ignoredMetaKey;
    }

    public Set<String> getIgnoredMetaKey() {
        return this.ignoredMetaKey;
    }

    public void setWingsRemoteResolver(WingsRemoteResolver wingsRemoteResolver) {
        this.wingsRemoteResolver = wingsRemoteResolver;
    }

    public WingsRemoteResolver getWingsRemoteResolver() {
        return this.wingsRemoteResolver;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public static interface Combo<T extends WingsAuthDetails>
    extends Ordered {
        public T buildDetails(@NotNull Enum<?> var1, @NotNull HttpServletRequest var2);
    }
}

