/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.cast.EnumConvertor;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;

public class DefaultWingsAuthTypeParser
implements WingsAuthTypeParser {
    private final Map<String, Enum<?>> strEnumMap;
    private final Map<Enum<?>, String> enumStrMap;
    private final String defaultAuthTypeName;
    private final Enum<?> defaultAuthTypeEnum;

    public DefaultWingsAuthTypeParser(Enum<?> defaultType, Map<String, Enum<?>> authType) {
        this.strEnumMap = Collections.unmodifiableMap(authType);
        HashMap map = new HashMap(this.strEnumMap.size());
        for (Map.Entry<String, Enum<?>> en : this.strEnumMap.entrySet()) {
            Enum<?> k = en.getValue();
            String v = (String)map.get(k);
            if (v == null) {
                map.put(k, en.getKey());
                continue;
            }
            throw new IllegalArgumentException("exist mapping for type=" + v + ", enum=" + EnumConvertor.enum2Str(k));
        }
        String dae = (String)map.get(defaultType);
        if (defaultType == null || dae == null) {
            throw new IllegalArgumentException("default MUST mapping, enum=" + EnumConvertor.enum2Str(defaultType));
        }
        this.enumStrMap = Collections.unmodifiableMap(map);
        this.defaultAuthTypeEnum = defaultType;
        this.defaultAuthTypeName = dae;
    }

    @Override
    @NotNull
    public Enum<?> parse(String at) {
        for (Map.Entry<String, Enum<?>> en : this.strEnumMap.entrySet()) {
            if (!en.getKey().equalsIgnoreCase(at)) continue;
            return en.getValue();
        }
        return this.defaultAuthTypeEnum;
    }

    @Override
    @NotNull
    public String parse(Enum<?> at) {
        if (at == null) {
            return this.defaultAuthTypeName;
        }
        return this.enumStrMap.getOrDefault(at, this.defaultAuthTypeName);
    }

    @Override
    @NotNull
    public Map<String, Enum<?>> types() {
        return this.strEnumMap;
    }
}

