/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.cookie;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(CookieRequestWrapper.class);
    private final Function<Cookie, Cookie> reader;
    private volatile Cookie[] cookies;

    public CookieRequestWrapper(HttpServletRequest request, Function<Cookie, Cookie> reader) {
        super(request);
        this.reader = reader;
    }

    public Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        Cookie[] cks = ((HttpServletRequest)super.getRequest()).getCookies();
        if (cks == null || cks.length == 0) {
            this.cookies = new Cookie[0];
        } else {
            this.cookies = new Cookie[cks.length];
            for (int i = 0; i < cks.length; ++i) {
                Cookie ck = cks[i];
                try {
                    this.cookies[i] = this.reader.apply(ck);
                }
                catch (Exception e) {
                    log.info("failed to wrap cookie=" + String.valueOf(ck), (Throwable)e);
                }
                if (this.cookies[i] != null) continue;
                this.cookies[i] = ck;
            }
        }
        return this.cookies;
    }
}

