/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.cookie;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;
import pro.fessional.wings.slardar.servlet.cookie.CookieRequestWrapper;
import pro.fessional.wings.slardar.servlet.cookie.CookieResponseWrapper;
import pro.fessional.wings.slardar.servlet.cookie.WingsCookieInterceptor;

public class WingsCookieFilter
extends OncePerRequestFilter
implements Ordered {
    public static final int ORDER = -29998000;
    private int order = -29998000;
    private final WingsCookieInterceptor interceptor;

    protected void doFilterInternal(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull FilterChain chain) throws ServletException, IOException {
        if (this.interceptor.notIntercept()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        CookieRequestWrapper request = new CookieRequestWrapper(req, this.interceptor::read);
        CookieResponseWrapper response = new CookieResponseWrapper(res, this.interceptor::write);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public WingsCookieFilter(WingsCookieInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public WingsCookieInterceptor getInterceptor() {
        return this.interceptor;
    }
}

