/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.cookie.impl;

import jakarta.servlet.http.Cookie;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.servlet.cookie.WingsCookieInterceptor;

public class WingsCookieInterceptorImpl
implements WingsCookieInterceptor {
    private String prefix = null;
    private WingsCookieInterceptor.Coder coder = WingsCookieInterceptor.Coder.Aes;
    private final Aes aes;
    private final Map<String, String> aliasEnc = new HashMap<String, String>();
    private final Map<String, String> aliasDec = new HashMap<String, String>();
    private final Set<String> codeNop = new HashSet<String>();
    private final Set<String> codeB64 = new HashSet<String>();
    private final Set<String> codeAes = new HashSet<String>();
    private final Map<String, Boolean> httpOnly = new HashMap<String, Boolean>();
    private final Map<String, Boolean> secure = new HashMap<String, Boolean>();
    private final Map<String, String> domain = new HashMap<String, String>();
    private final Map<String, String> path = new HashMap<String, String>();

    public WingsCookieInterceptorImpl(String aesKey) {
        this.aes = StringUtils.hasText((String)aesKey) ? Aes256.of((String)aesKey) : null;
    }

    @Override
    public boolean notIntercept() {
        return this.prefix == null && this.coder == WingsCookieInterceptor.Coder.Nop && this.aliasEnc.isEmpty() && this.codeB64.isEmpty() && (this.aes == null || this.codeAes.isEmpty()) && this.httpOnly.isEmpty() && this.secure.isEmpty() && this.path.isEmpty() && this.domain.isEmpty();
    }

    @Override
    public Cookie read(Cookie cookie) {
        String value;
        String n;
        if (cookie == null) {
            return null;
        }
        boolean dirty = false;
        String name = cookie.getName();
        if (this.prefix != null && name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length());
            dirty = true;
        }
        if ((n = this.aliasDec.get(name)) != null) {
            name = n;
            dirty = true;
        }
        if ((value = cookie.getValue()) == null) {
            return cookie;
        }
        if (this.codeAes.contains(name)) {
            if (value.length() >= 16) {
                value = this.aes.decode64(value);
                dirty = true;
            }
        } else if (this.codeB64.contains(name)) {
            if (value.length() >= 2) {
                value = Base64.de2str((String)value);
                dirty = true;
            }
        } else if (this.codeNop.contains(name)) {
            DummyBlock.empty();
        } else if (this.coder == WingsCookieInterceptor.Coder.Aes && value.length() >= 16) {
            value = this.aes.decode64(value);
            dirty = true;
        } else if (this.coder == WingsCookieInterceptor.Coder.B64 && value.length() >= 2) {
            value = Base64.de2str((String)value);
            dirty = true;
        }
        return dirty ? this.copyCookie(cookie, name, value) : cookie;
    }

    @Override
    public Cookie write(Cookie cookie) {
        String n;
        String ph;
        String dm;
        Boolean se;
        if (cookie == null) {
            return null;
        }
        boolean did = false;
        Object name = cookie.getName();
        String value = cookie.getValue();
        if (this.codeAes.contains(name)) {
            value = this.aes.encode64(value);
            did = true;
        } else if (this.codeB64.contains(name)) {
            value = Base64.encode((String)value);
            did = true;
        } else if (this.codeNop.contains(name)) {
            DummyBlock.empty();
        } else if (this.coder == WingsCookieInterceptor.Coder.Aes) {
            value = this.aes.encode64(value);
            did = true;
        } else if (this.coder == WingsCookieInterceptor.Coder.B64) {
            value = Base64.encode((String)value);
            did = true;
        }
        Boolean ho = this.httpOnly.get(name);
        if (ho != null) {
            cookie.setHttpOnly(ho.booleanValue());
        }
        if ((se = this.secure.get(name)) != null) {
            cookie.setSecure(se.booleanValue());
        }
        if ((dm = this.domain.get(name)) != null) {
            cookie.setDomain(dm);
        }
        if ((ph = this.path.get(name)) != null) {
            cookie.setPath(ph);
        }
        if ((n = this.aliasEnc.get(name)) != null) {
            name = n;
            did = true;
        }
        if (this.prefix != null) {
            name = this.prefix + (String)name;
            did = true;
        }
        return did ? this.copyCookie(cookie, (String)name, value) : cookie;
    }

    @NotNull
    private Cookie copyCookie(Cookie cookie, String name, String value) {
        String path;
        Cookie nc = new Cookie(name, value);
        String domain = cookie.getDomain();
        if (domain != null) {
            nc.setDomain(domain);
        }
        if ((path = cookie.getPath()) != null) {
            nc.setPath(path);
        }
        nc.setMaxAge(cookie.getMaxAge());
        nc.setHttpOnly(cookie.isHttpOnly());
        nc.setSecure(cookie.getSecure());
        return nc;
    }

    public void setPrefix(String prefix) {
        this.prefix = StringUtils.hasText((String)prefix) ? prefix : null;
    }

    public void addAlias(Map<String, String> alias) {
        for (Map.Entry<String, String> en : alias.entrySet()) {
            String v;
            String k = en.getKey();
            if (k.equals(v = en.getValue()) || CommonPropHelper.notValue((String)v)) continue;
            this.aliasEnc.put(k, v);
            this.aliasDec.put(v, k);
        }
        if (this.aliasEnc.size() != this.aliasDec.size()) {
            throw new IllegalArgumentException("has alias is not one-to-one mapping");
        }
    }

    public void delAlias(String name) {
        String v = this.aliasEnc.remove(name);
        if (v != null) {
            this.aliasDec.remove(v);
        }
        if (this.aliasEnc.size() != this.aliasDec.size()) {
            throw new IllegalArgumentException("has alias is not one-to-one mapping");
        }
    }

    public void addCodes(WingsCookieInterceptor.Coder code, Collection<String> names) {
        this.getCodeNames(code).addAll(names);
    }

    public void delCodes(WingsCookieInterceptor.Coder code, Collection<String> names) {
        this.getCodeNames(code).removeAll(names);
    }

    public void addHttpOnly(String name, boolean yes) {
        this.httpOnly.put(name, yes);
    }

    public void delHttpOnly(String name) {
        this.httpOnly.remove(name);
    }

    public void addSecure(String name, boolean yes) {
        this.secure.put(name, yes);
    }

    public void delSecure(String name) {
        this.secure.remove(name);
    }

    public void addDomain(String domain, Collection<String> names) {
        for (String name : names) {
            this.domain.put(name, domain);
        }
    }

    public void delDomain(Collection<String> names) {
        for (String name : names) {
            this.domain.remove(name);
        }
    }

    public void addPath(String path, Collection<String> names) {
        for (String name : names) {
            this.path.put(name, path);
        }
    }

    public void delPath(Collection<String> names) {
        for (String name : names) {
            this.path.remove(name);
        }
    }

    private Set<String> getCodeNames(WingsCookieInterceptor.Coder code) {
        if (code == WingsCookieInterceptor.Coder.B64) {
            return this.codeB64;
        }
        if (code == WingsCookieInterceptor.Coder.Aes) {
            return this.codeAes;
        }
        return this.codeNop;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setCoder(WingsCookieInterceptor.Coder coder) {
        this.coder = coder;
    }

    public WingsCookieInterceptor.Coder getCoder() {
        return this.coder;
    }
}

