/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.resolver;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.web.servlet.i18n.AbstractLocaleContextResolver;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.mirana.i18n.LocaleResolver;
import pro.fessional.mirana.i18n.ZoneIdResolver;
import pro.fessional.wings.slardar.context.AttributeHolder;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.security.WingsUserDetails;

public class WingsLocaleResolver
extends AbstractLocaleContextResolver {
    private final Set<String> localeParam = new LinkedHashSet<String>();
    private final Set<String> localeCookie = new LinkedHashSet<String>();
    private final Set<String> localeHeader = new LinkedHashSet<String>();
    private final Set<String> zoneidParam = new LinkedHashSet<String>();
    private final Set<String> zoneidCookie = new LinkedHashSet<String>();
    private final Set<String> zoneidHeader = new LinkedHashSet<String>();

    public void addLocaleCookie(Collection<String> keys) {
        this.localeCookie.addAll(keys);
    }

    public void addLocaleHeader(Collection<String> keys) {
        this.localeHeader.addAll(keys);
    }

    public void addLocaleParam(Collection<String> keys) {
        this.localeParam.addAll(keys);
    }

    public void addZoneidCookie(Collection<String> keys) {
        this.zoneidCookie.addAll(keys);
    }

    public void addZoneidHeader(Collection<String> keys) {
        this.zoneidHeader.addAll(keys);
    }

    public void addZoneidParam(Collection<String> keys) {
        this.zoneidParam.addAll(keys);
    }

    @NotNull
    public LocaleContext resolveLocaleContext(@NotNull HttpServletRequest request) {
        return this.resolveI18nContext(request);
    }

    @NotNull
    public TimeZoneAwareLocaleContext resolveI18nContext(HttpServletRequest request) {
        return this.resolveI18nContext(request, null);
    }

    @NotNull
    public TimeZoneAwareLocaleContext resolveI18nContext(HttpServletRequest request, Long userId) {
        Object obj = request.getAttribute("WINGS.ATTR.I18N_CONTEXT");
        if (obj instanceof TimeZoneAwareLocaleContext) {
            TimeZoneAwareLocaleContext alc = (TimeZoneAwareLocaleContext)obj;
            return alc;
        }
        Locale locale = this.resolveUserLocale(request);
        TimeZone timeZone = this.resolveUserTimeZone(request);
        if (locale == null || timeZone == null) {
            WingsUserDetails details = SecurityContextUtil.getUserDetails(false);
            if (locale == null) {
                if (details == null) {
                    if (userId != null) {
                        locale = (Locale)AttributeHolder.tryAttr((TypedReg)TerminalAttribute.LocaleByUid, (Object)userId, (boolean)false);
                    }
                } else {
                    locale = details.getLocale();
                }
                if (locale == null) {
                    locale = TerminalContext.defaultLocale();
                }
            }
            if (timeZone == null) {
                if (details == null) {
                    ZoneId zid;
                    if (userId != null && (zid = (ZoneId)AttributeHolder.tryAttr((TypedReg)TerminalAttribute.ZoneIdByUid, (Object)userId, (boolean)false)) != null) {
                        timeZone = TimeZone.getTimeZone(zid);
                    }
                } else {
                    timeZone = TimeZone.getTimeZone(details.getZoneId());
                }
                if (timeZone == null) {
                    timeZone = TerminalContext.defaultTimeZone();
                }
            }
        }
        SimpleTimeZoneAwareLocaleContext context = new SimpleTimeZoneAwareLocaleContext(locale, timeZone);
        request.setAttribute("WINGS.ATTR.I18N_CONTEXT", (Object)context);
        return context;
    }

    public void setLocaleContext(@NotNull HttpServletRequest request, HttpServletResponse response, LocaleContext context) {
        TimeZone timeZone;
        if (context instanceof TimeZoneAwareLocaleContext) {
            request.setAttribute("WINGS.ATTR.I18N_CONTEXT", (Object)context);
            return;
        }
        Locale locale = context.getLocale();
        if (locale == null) {
            locale = this.resolveUserLocale(request);
        }
        if (locale == null) {
            locale = TerminalContext.defaultLocale();
        }
        if ((timeZone = this.resolveUserTimeZone(request)) == null) {
            timeZone = TerminalContext.defaultTimeZone();
        }
        context = new SimpleTimeZoneAwareLocaleContext(locale, timeZone);
        request.setAttribute("WINGS.ATTR.I18N_CONTEXT", (Object)context);
    }

    private TimeZone resolveUserTimeZone(HttpServletRequest request) {
        for (String s : this.zoneidParam) {
            String q = request.getParameter(s);
            if (q == null || q.isEmpty()) continue;
            return ZoneIdResolver.timeZone((String)q);
        }
        for (String s : this.zoneidHeader) {
            String h = request.getHeader(s);
            if (h == null || h.isEmpty()) continue;
            return ZoneIdResolver.timeZone((String)h);
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (String s : this.zoneidCookie) {
                for (Cookie c : cookies) {
                    if (!c.getName().equalsIgnoreCase(s)) continue;
                    return ZoneIdResolver.timeZone((String)c.getValue());
                }
            }
        }
        return null;
    }

    private Locale resolveUserLocale(HttpServletRequest request) {
        for (String s : this.localeParam) {
            String q = request.getParameter(s);
            if (q == null || q.isEmpty()) continue;
            return LocaleResolver.locale((String)q);
        }
        for (String s : this.localeHeader) {
            String h = request.getHeader(s);
            if (h == null || h.isEmpty()) continue;
            return LocaleResolver.locale((String)h);
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (String s : this.localeCookie) {
                for (Cookie c : cookies) {
                    if (!c.getName().equalsIgnoreCase(s)) continue;
                    return LocaleResolver.locale((String)c.getValue());
                }
            }
        }
        return null;
    }

    public Set<String> getLocaleParam() {
        return this.localeParam;
    }

    public Set<String> getLocaleCookie() {
        return this.localeCookie;
    }

    public Set<String> getLocaleHeader() {
        return this.localeHeader;
    }

    public Set<String> getZoneidParam() {
        return this.zoneidParam;
    }

    public Set<String> getZoneidCookie() {
        return this.zoneidCookie;
    }

    public Set<String> getZoneidHeader() {
        return this.zoneidHeader;
    }

    public static class Context
    implements TimeZoneAwareLocaleContext {
        private final Locale locale;
        private final TimeZone timeZone;
        private final ZoneId zoneId;

        public Context(Locale locale, TimeZone timeZone, ZoneId zoneId) {
            this.locale = locale;
            this.timeZone = timeZone;
            this.zoneId = zoneId;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public ZoneId getZoneId() {
            return this.zoneId;
        }
    }
}

