/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.stream;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.web.util.WebUtils;
import pro.fessional.wings.slardar.servlet.stream.CirclePart;
import pro.fessional.wings.slardar.servlet.stream.CircleServletInputStream;

public class ReuseStreamRequestWrapper
extends HttpServletRequestWrapper {
    private static final AtomicLong RequestSeq = new AtomicLong(0L);
    private final long requestSeq = RequestSeq.getAndIncrement();
    private ServletInputStream inputStream;
    private BufferedReader bufferedReader;
    private Collection<Part> parts = null;
    private boolean backend = false;

    public static ReuseStreamRequestWrapper infer(ServletRequest request) {
        return (ReuseStreamRequestWrapper)((Object)WebUtils.getNativeRequest((ServletRequest)request, ReuseStreamRequestWrapper.class));
    }

    public ReuseStreamRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public boolean circleInputStream(boolean quiet) {
        if (this.backend) {
            if (quiet) {
                return false;
            }
            throw new IllegalStateException("MUST circle before using");
        }
        if (this.inputStream == null) {
            this.inputStream = this.initCircleServletInputStream(this.getRequest());
        }
        return true;
    }

    private CircleServletInputStream initCircleServletInputStream(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return new CircleServletInputStream(request.getInputStream());
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String contentType = req.getContentType();
        boolean multip = false;
        boolean simple = true;
        if ("POST".equalsIgnoreCase(req.getMethod())) {
            if (contentType.contains("multipart/form-data")) {
                multip = true;
                simple = false;
            } else if (contentType.contains("application/x-www-form-urlencoded")) {
                simple = false;
            }
        }
        if (simple) {
            return new CircleServletInputStream(request.getInputStream());
        }
        Map form = req.getParameterMap();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String encoding = this.getCharacterEncoding();
        Iterator it = form.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            String name = (String)en.getKey();
            Iterator<String> vi = Arrays.asList((String[])en.getValue()).iterator();
            while (vi.hasNext()) {
                String value = vi.next();
                bos.write(URLEncoder.encode(name, encoding).getBytes());
                if (value == null) continue;
                bos.write(61);
                bos.write(URLEncoder.encode(value, encoding).getBytes());
                if (!vi.hasNext()) continue;
                bos.write(38);
            }
            if (!it.hasNext()) continue;
            bos.write(38);
        }
        if (multip) {
            Collection pts = req.getParts();
            this.parts = new ArrayList<Part>(pts.size());
            for (Part pt : pts) {
                this.parts.add(new CirclePart(pt));
            }
        }
        return new CircleServletInputStream(req.getInputStream(), bos);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.backend = true;
            return this.getRequest().getInputStream();
        }
        return this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStream == null) {
            this.backend = true;
            return this.getRequest().getReader();
        }
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.bufferedReader;
    }

    public String getCharacterEncoding() {
        String enc = this.getRequest().getCharacterEncoding();
        return enc != null ? enc : "ISO-8859-1";
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.parts != null ? this.parts : super.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.parts == null) {
            return super.getPart(name);
        }
        for (Part part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    public long getRequestSeq() {
        return this.requestSeq;
    }
}

