/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.stream;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;
import pro.fessional.wings.slardar.servlet.stream.RequestResponseLogging;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamRequestWrapper;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamResponseWrapper;

public class WingsReuseStreamFilter
extends OncePerRequestFilter
implements Ordered {
    private int order = -30000000;
    private RequestResponseLogging requestResponseLogging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull FilterChain chain) throws ServletException, IOException {
        RequestResponseLogging.Conf cnf;
        ReuseStreamRequestWrapper request = new ReuseStreamRequestWrapper(req);
        ReuseStreamResponseWrapper response = new ReuseStreamResponseWrapper(res);
        if (this.requestResponseLogging != null) {
            cnf = this.requestResponseLogging.loggingConfig(request);
            if (cnf != null) {
                if (cnf.isRequestEnable()) {
                    if (cnf.isRequestPayload()) {
                        request.circleInputStream(false);
                    }
                    this.requestResponseLogging.beforeRequest(cnf, request);
                }
                if (cnf.isResponseEnable() && cnf.isResponsePayload()) {
                    response.cachingOutputStream(false);
                }
            }
        } else {
            cnf = null;
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (cnf != null && cnf.isResponseEnable()) {
                this.requestResponseLogging.afterResponse(cnf, request, response);
            }
        }
        response.copyBodyToResponse();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setRequestResponseLogging(RequestResponseLogging requestResponseLogging) {
        this.requestResponseLogging = requestResponseLogging;
    }

    public int getOrder() {
        return this.order;
    }

    public RequestResponseLogging getRequestResponseLogging() {
        return this.requestResponseLogging;
    }
}

