/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.session;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.util.Assert;
import pro.fessional.wings.slardar.session.SessionTokenEncoder;

public class WingsSessionIdResolver
implements HttpSessionIdResolver {
    private final List<HttpSessionIdResolver> httpSessionIdResolvers;
    private SessionTokenEncoder sessionTokenEncoder;

    public WingsSessionIdResolver(List<HttpSessionIdResolver> httpSessionIdResolvers) {
        this.httpSessionIdResolvers = httpSessionIdResolvers;
    }

    public WingsSessionIdResolver(HttpSessionIdResolver ... resolvers) {
        Assert.notEmpty((Object[])resolvers, (String)"need HttpSessionIdResolver");
        this.httpSessionIdResolvers = new ArrayList<HttpSessionIdResolver>(resolvers.length);
        for (HttpSessionIdResolver resolver : resolvers) {
            if (resolver == null) continue;
            this.httpSessionIdResolvers.add(resolver);
        }
    }

    public List<String> resolveSessionIds(HttpServletRequest request) {
        for (HttpSessionIdResolver resolver : this.httpSessionIdResolvers) {
            List<String> ids = resolver.resolveSessionIds(request);
            if (ids == null || ids.isEmpty()) continue;
            return this.sessionTokenEncoder == null ? ids : this.sessionTokenEncoder.decode(ids, request);
        }
        return Collections.emptyList();
    }

    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (this.sessionTokenEncoder != null) {
            sessionId = this.sessionTokenEncoder.encode(sessionId, request);
        }
        for (HttpSessionIdResolver resolver : this.httpSessionIdResolvers) {
            resolver.setSessionId(request, response, sessionId);
        }
    }

    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        for (HttpSessionIdResolver resolver : this.httpSessionIdResolvers) {
            resolver.expireSession(request, response);
        }
    }

    public void setCookieSerializer(CookieSerializer cookieSerializer) {
        for (HttpSessionIdResolver resolver : this.httpSessionIdResolvers) {
            if (!(resolver instanceof CookieHttpSessionIdResolver)) continue;
            CookieHttpSessionIdResolver csr = (CookieHttpSessionIdResolver)resolver;
            csr.setCookieSerializer(cookieSerializer);
        }
    }

    @Autowired(required=false)
    public void setSessionTokenEncoder(SessionTokenEncoder sessionTokenEncoder) {
        this.sessionTokenEncoder = sessionTokenEncoder;
    }
}

