/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerMapping;
import pro.fessional.mirana.text.Wildcard;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.domainx.DefaultDomainRequestMatcher;
import pro.fessional.wings.slardar.domainx.WingsDomainExtendFilter;
import pro.fessional.wings.slardar.spring.prop.DomainExtendProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.domainx", value=false)
public class SlardarDomainExtendConfiguration {
    private static final Log log = LogFactory.getLog(SlardarDomainExtendConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WingsDomainExtendFilter wingsDomainExtendFilter(DomainExtendProp config, ApplicationContext context) {
        log.info((Object)"SlardarWebmvc spring-bean wingsDomainExtendFilter");
        HashMap<String, List<String[]>> hostMatcher = new HashMap<String, List<String[]>>();
        for (Map.Entry<String, Set<String>> entry : config.getHost().entrySet()) {
            Set<String> vs = entry.getValue();
            ArrayList<String[]> ls = new ArrayList<String[]>(vs.size());
            for (String v : vs) {
                ls.add(Wildcard.compile((CharSequence)v));
            }
            String key = entry.getKey();
            log.info((Object)(" - conf Domain filter - " + key + ":" + String.join((CharSequence)",", vs)));
            hostMatcher.put(key, ls);
        }
        Object prefix = config.getPrefix();
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        Supplier<List<HandlerMapping>> supplier = () -> {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
            ArrayList handlerMappings = new ArrayList(matchingBeans.values());
            AnnotationAwareOrderComparator.sort(handlerMappings);
            return handlerMappings;
        };
        DefaultDomainRequestMatcher requestMatcher = new DefaultDomainRequestMatcher((String)prefix, config.getOtherUrl(), config.getCacheSize(), supplier);
        return new WingsDomainExtendFilter(hostMatcher, requestMatcher);
    }
}

