/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.i18n.I18nString;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.autozone.AutoZoneType;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalDateDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalDateTimeSerializer;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonOffsetDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonOffsetDateTimeSerializer;
import pro.fessional.wings.slardar.autozone.json.JacksonZonedDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonZonedDateTimeSerializer;
import pro.fessional.wings.slardar.jackson.AutoRegisterPropertyFilter;
import pro.fessional.wings.slardar.jackson.EmptyValuePropertyFilter;
import pro.fessional.wings.slardar.jackson.FormatNumberSerializer;
import pro.fessional.wings.slardar.jackson.I18nResultPropertyFilter;
import pro.fessional.wings.slardar.jackson.I18nStringSerializer;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.slardar.jackson.ResourceSerializer;
import pro.fessional.wings.slardar.spring.prop.SlardarDatetimeProp;
import pro.fessional.wings.slardar.spring.prop.SlardarJacksonProp;
import pro.fessional.wings.slardar.spring.prop.SlardarNumberProp;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DateSerializer.class})
@ConditionalWingsEnabled
public class SlardarJacksonWebConfiguration {
    private static final Log log = LogFactory.getLog(SlardarJacksonWebConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.jackson-datetime")
    public Jackson2ObjectMapperBuilderCustomizer customizeJacksonDatetime(SlardarDatetimeProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean customizeJacksonDatetime");
        return builder -> {
            DateTimeFormatter date = DateTimeFormatter.ofPattern(prop.getDate().getFormat());
            List datePsr = prop.getDate().getSupport().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
            builder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(date));
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)new JacksonLocalDateDeserializer(date, datePsr));
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer LocalDate");
            DateTimeFormatter time = DateTimeFormatter.ofPattern(prop.getTime().getFormat());
            List timePsr = prop.getTime().getSupport().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
            builder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(time));
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)new JacksonLocalTimeDeserializer(time, timePsr));
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer LocalTime");
            DateTimeFormatter full = DateTimeFormatter.ofPattern(prop.getDatetime().getFormat());
            AutoZoneType autoLocal = AutoZoneType.valueOf((boolean)prop.getDatetime().isAuto());
            JacksonLocalDateTimeSerializer.defaultFormatter = full;
            JacksonLocalDateTimeSerializer.defaultAutoZone = autoLocal;
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new JacksonLocalDateTimeSerializer(full, autoLocal));
            List fullPsr = prop.getDatetime().getSupport().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new JacksonLocalDateTimeDeserializer(full, fullPsr, autoLocal));
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer LocalDateTime");
            DateTimeFormatter zoned = DateTimeFormatter.ofPattern(prop.getZoned().getFormat());
            AutoZoneType autoZone = AutoZoneType.valueOf((boolean)prop.getZoned().isAuto());
            JacksonZonedDateTimeSerializer.defaultFormatter = zoned;
            JacksonZonedDateTimeSerializer.defaultAutoZone = autoZone;
            builder.serializerByType(ZonedDateTime.class, (JsonSerializer)new JacksonZonedDateTimeSerializer(zoned, autoZone));
            List zonePsr = prop.getZoned().getSupport().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
            builder.deserializerByType(ZonedDateTime.class, (JsonDeserializer)new JacksonZonedDateTimeDeserializer(zoned, zonePsr, autoZone));
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer ZonedDateTime");
            DateTimeFormatter offset = DateTimeFormatter.ofPattern(prop.getOffset().getFormat());
            AutoZoneType autoOffset = AutoZoneType.valueOf((boolean)prop.getOffset().isAuto());
            JacksonOffsetDateTimeSerializer.defaultFormatter = offset;
            JacksonOffsetDateTimeSerializer.defaultAutoZone = autoOffset;
            builder.serializerByType(OffsetDateTime.class, (JsonSerializer)new JacksonOffsetDateTimeSerializer(offset, autoOffset));
            List offPsr = prop.getZoned().getSupport().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
            builder.deserializerByType(OffsetDateTime.class, (JsonDeserializer)new JacksonOffsetDateTimeDeserializer(offset, offPsr, autoOffset));
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer OffsetDateTime");
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.jackson-empty")
    public Jackson2ObjectMapperBuilderCustomizer customizeJacksonEmpty(SlardarJacksonProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean customizeJacksonEmpty");
        return builder -> {
            if (StringUtils.hasText((String)prop.getEmptyDate()) || prop.isEmptyMap() || prop.isEmptyList()) {
                log.info((Object)"SlardarWebmvc conf EmptyValuePropertyFilter's EmptyDateMixin");
                builder.mixIn(Object.class, EmptyValuePropertyFilter.EmptyDateMixin.class);
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.jackson-number")
    public Jackson2ObjectMapperBuilderCustomizer customizeJacksonNumber(SlardarNumberProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean customizeJacksonNumber");
        return builder -> {
            SlardarNumberProp.Nf decimal;
            SlardarNumberProp.Nf floats;
            SlardarNumberProp.Nf ints = prop.getInteger();
            if (ints.isEnable()) {
                DecimalFormat df = ints.getWellFormat();
                FormatNumberSerializer.Digital digital = ints.getDigital();
                log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer Integer&Long serializer");
                builder.serializerByType(Integer.class, (JsonSerializer)new FormatNumberSerializer(Integer.class, df, digital));
                builder.serializerByType(Integer.TYPE, (JsonSerializer)new FormatNumberSerializer(Integer.TYPE, df, digital));
                builder.serializerByType(Long.class, (JsonSerializer)new FormatNumberSerializer(Long.class, df, digital));
                builder.serializerByType(Long.TYPE, (JsonSerializer)new FormatNumberSerializer(Long.TYPE, df, digital));
            }
            if ((floats = prop.getFloats()).isEnable()) {
                DecimalFormat df = floats.getWellFormat();
                FormatNumberSerializer.Digital digital = floats.getDigital();
                log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer Float&Double serializer");
                builder.serializerByType(Float.class, (JsonSerializer)new FormatNumberSerializer(Float.class, df, digital));
                builder.serializerByType(Float.TYPE, (JsonSerializer)new FormatNumberSerializer(Float.TYPE, df, digital));
                builder.serializerByType(Double.class, (JsonSerializer)new FormatNumberSerializer(Double.class, df, digital));
                builder.serializerByType(Double.TYPE, (JsonSerializer)new FormatNumberSerializer(Double.TYPE, df, digital));
            }
            if ((decimal = prop.getDecimal()).isEnable()) {
                DecimalFormat df = decimal.getWellFormat();
                log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer BigDecimal/BigInteger serializer");
                builder.serializerByType(BigDecimal.class, (JsonSerializer)new FormatNumberSerializer(BigDecimal.class, df, decimal.getDigital()));
                builder.serializerByType(BigInteger.class, (JsonSerializer)new FormatNumberSerializer(BigInteger.class, df, decimal.getDigital()));
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.jackson-resource")
    public Jackson2ObjectMapperBuilderCustomizer customizeJacksonResource() {
        log.info((Object)"SlardarWebmvc spring-bean customizeJacksonResource");
        return builder -> {
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer Resource");
            builder.serializerByType(Resource.class, (JsonSerializer)new ResourceSerializer());
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.jackson-result")
    public Jackson2ObjectMapperBuilderCustomizer customizeJacksonResult(SlardarJacksonProp prop, MessageSource source) {
        log.info((Object)"SlardarWebmvc spring-bean customizerObjectMapperJackson");
        return builder -> {
            if (prop.isI18nResult()) {
                log.info((Object)"SlardarWebmvc conf I18nResultPropertyFilter's I18nResultMixin");
                builder.serializerByType(I18nString.class, (JsonSerializer)new I18nStringSerializer(source, true));
                builder.serializerByType(CharSequence.class, (JsonSerializer)new I18nStringSerializer(source, false));
                builder.mixIn(R.class, I18nResultPropertyFilter.I18nResultMixin.class);
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public Jackson2ObjectMapperBuilderCustomizer jacksonCustomizerFilter(FilterProvider filterProvider) {
        log.info((Object)"SlardarWebmvc spring-bean jacksonCustomizerFilter");
        return builder -> {
            log.info((Object)"SlardarWebmvc conf Jackson2ObjectMapperBuilderCustomizer filters");
            builder.filters(filterProvider);
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public SimpleFilterProvider jacksonFilterProvider(List<AutoRegisterPropertyFilter> filters) {
        log.info((Object)"SlardarWebmvc spring-bean jacksonFilterProvider");
        SimpleFilterProvider bean = new SimpleFilterProvider();
        for (AutoRegisterPropertyFilter filter : filters) {
            bean.addFilter(filter.getId(), (PropertyFilter)filter);
        }
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationStartedEventRunner jacksonHelperRunner(Jackson2ObjectMapperBuilder builder) {
        log.info((Object)"SlardarWebmvc spring-runs jacksonHelperRunner");
        return new ApplicationStartedEventRunner(-90000000, ignored -> {
            log.info((Object)"SlardarWebmvc spring-conf JacksonHelper.initGlobal");
            JacksonHelper.initGlobal((ObjectMapper)builder.createXmlMapper(false).build(), (XmlMapper)((XmlMapper)builder.createXmlMapper(true).build()));
        });
    }
}

