/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.servlet.resolver.WingsLocaleResolver;
import pro.fessional.wings.slardar.spring.prop.SlardarLocaleProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={LocaleResolver.class})
public class SlardarLocaleConfiguration {
    private final Log log = LogFactory.getLog(SlardarLocaleConfiguration.class);

    @Bean(value={"localeResolver"})
    @ConditionalWingsEnabled
    public WingsLocaleResolver localeResolver(SlardarLocaleProp conf) {
        this.log.info((Object)"SlardarWebmvc spring-bean wingsLocaleResolver");
        WingsLocaleResolver resolver = new WingsLocaleResolver();
        resolver.addLocaleCookie(conf.getLocaleCookie());
        resolver.addLocaleHeader(conf.getLocaleHeader());
        resolver.addLocaleParam(conf.getLocaleParam());
        resolver.addZoneidCookie(conf.getZoneidCookie());
        resolver.addZoneidHeader(conf.getZoneidHeader());
        resolver.addZoneidParam(conf.getZoneidParam());
        return resolver;
    }
}

