/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Undertow.class})
@ConditionalWingsEnabled
public class SlardarUndertowConfiguration {
    private static final Log log = LogFactory.getLog(SlardarUndertowConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> ut026010Customizer(ServerProperties properties) {
        log.info((Object)"SlardarWebmvc spring-bean ut026010Customizer");
        UndertowDeploymentInfoCustomizer customizer = deploymentInfo -> {
            ServerProperties.Undertow undertow = properties.getUndertow();
            Boolean dt = undertow.getDirectBuffers();
            boolean dtb = dt == null || dt != false;
            DataSize bs = undertow.getBufferSize();
            int bss = bs == null ? 8192 : (int)bs.toBytes();
            Integer it = undertow.getThreads().getIo();
            int its = it == null ? Runtime.getRuntime().availableProcessors() : it.intValue();
            Integer wt = undertow.getThreads().getWorker();
            int wks = wt == null ? its * 8 : wt;
            log.info((Object)("config Undertow websocket buffer, direct=" + dtb + ", bufferSize=" + bss + ",maximumPoolSize=" + wks + ", threadLocalCacheSize=" + its));
            DefaultByteBufferPool buffers = new DefaultByteBufferPool(dtb, bss, wks, its);
            WebSocketDeploymentInfo info = new WebSocketDeploymentInfo();
            info.setBuffers((ByteBufferPool)buffers);
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)info);
        };
        return factory -> factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{customizer});
    }
}

