/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.prop;

import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="wings.slardar.swagger")
public class SlardarSwaggerProp {
    public static final String Key = "wings.slardar.swagger";
    private String title = "";
    public static final String Key$title = "wings.slardar.swagger.title";
    private String description = "";
    public static final String Key$description = "wings.slardar.swagger.description";
    private String version = "";
    public static final String Key$version = "wings.slardar.swagger.version";
    private Map<String, EnabledParameter> param = new HashMap<String, EnabledParameter>();
    public static final String Key$param = "wings.slardar.swagger.param";
    private Map<String, String> accept = new HashMap<String, String>();
    public static final String Key$accept = "wings.slardar.swagger.accept";
    private boolean flatPagequery = true;
    public static final String Key$flatPagequery = "wings.slardar.swagger.flat-pagequery";

    public List<Parameter> toRefPara() {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Map.Entry<String, EnabledParameter> en : this.param.entrySet()) {
            EnabledParameter para = en.getValue();
            if (!para.isEnable()) continue;
            Parameter sub = this.subParam(para);
            sub.set$ref("#/components/parameters/" + en.getKey());
            result.add(sub);
        }
        return result;
    }

    public Map<String, Parameter> toComPara() {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Map.Entry<String, EnabledParameter> en : this.param.entrySet()) {
            EnabledParameter para = en.getValue();
            if (!para.isEnable()) continue;
            Parameter sub = this.subParam(para);
            BeanUtils.copyProperties((Object)((Object)para), (Object)sub);
            map.put(en.getKey(), para);
        }
        return map;
    }

    @NotNull
    private Parameter subParam(Parameter para) {
        CookieParameter sub;
        String in = para.getIn();
        if ("cookie".equalsIgnoreCase(in)) {
            sub = new CookieParameter();
        } else if ("header".equalsIgnoreCase(in)) {
            sub = new HeaderParameter();
        } else if ("query".equalsIgnoreCase(in)) {
            sub = new QueryParameter();
        } else if ("path".equalsIgnoreCase(in)) {
            sub = new PathParameter();
        } else {
            throw new IllegalArgumentException("unsupported type=" + String.valueOf(para));
        }
        return sub;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, EnabledParameter> getParam() {
        return this.param;
    }

    public Map<String, String> getAccept() {
        return this.accept;
    }

    public boolean isFlatPagequery() {
        return this.flatPagequery;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setParam(Map<String, EnabledParameter> param) {
        this.param = param;
    }

    public void setAccept(Map<String, String> accept) {
        this.accept = accept;
    }

    public void setFlatPagequery(boolean flatPagequery) {
        this.flatPagequery = flatPagequery;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlardarSwaggerProp)) {
            return false;
        }
        SlardarSwaggerProp other = (SlardarSwaggerProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFlatPagequery() != other.isFlatPagequery()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, EnabledParameter> this$param = this.getParam();
        Map<String, EnabledParameter> other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        Map<String, String> this$accept = this.getAccept();
        Map<String, String> other$accept = other.getAccept();
        return !(this$accept == null ? other$accept != null : !((Object)this$accept).equals(other$accept));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SlardarSwaggerProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlatPagequery() ? 79 : 97);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, EnabledParameter> $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        Map<String, String> $accept = this.getAccept();
        result = result * 59 + ($accept == null ? 43 : ((Object)$accept).hashCode());
        return result;
    }

    @NotNull
    public String toString() {
        return "SlardarSwaggerProp(title=" + this.getTitle() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", param=" + String.valueOf(this.getParam()) + ", accept=" + String.valueOf(this.getAccept()) + ", flatPagequery=" + this.isFlatPagequery() + ")";
    }

    public static class EnabledParameter
    extends Parameter {
        private boolean enable = true;

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isEnable() {
            return this.enable;
        }
    }
}

