/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import org.jetbrains.annotations.NotNull;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.page.PageDefault;
import pro.fessional.mirana.page.PageQuery;

public class PageQueryArgumentResolver
implements HandlerMethodArgumentResolver {
    private int page = 1;
    private int size = 20;
    private String[] pageAlias = Null.StrArr;
    private String[] sizeAlias = Null.StrArr;
    private String[] sortAlias = Null.StrArr;

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        return PageQuery.class.equals((Object)parameter.getParameterType());
    }

    public PageQuery resolveArgument(@NotNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        PageDefault annotation = (PageDefault)parameter.getParameterAnnotation(PageDefault.class);
        int pg = this.page;
        int sz = this.size;
        String sort = "";
        String[] pas = this.pageAlias;
        String[] szs = this.sizeAlias;
        String[] sta = this.sortAlias;
        if (annotation != null) {
            pg = Math.max(pg, annotation.page());
            sz = Math.max(sz, annotation.size());
            sort = this.notEmpty(sort, annotation.sort());
            pas = this.notEmpty(pas, annotation.pageAlias());
            szs = this.notEmpty(szs, annotation.sizeAlias());
            sta = this.notEmpty(sta, annotation.sortAlias());
        }
        pg = this.getParameter(pg, webRequest, pas);
        sz = this.getParameter(sz, webRequest, szs);
        sort = this.getParameter(sort, webRequest, sta);
        return new PageQuery(pg, sz, sort);
    }

    private String getParameter(String df, NativeWebRequest rq, String[] al) {
        for (String s : al) {
            String p = rq.getParameter(s);
            if (p == null || p.isEmpty()) continue;
            return p;
        }
        return df;
    }

    private int getParameter(int df, NativeWebRequest rq, String[] al) {
        for (String s : al) {
            String p = rq.getParameter(s);
            if (p == null || p.isEmpty()) continue;
            try {
                return Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return df;
    }

    private String notEmpty(String df, String s1) {
        if (s1 == null || s1.isEmpty()) {
            return df;
        }
        return s1;
    }

    private String[] notEmpty(String[] df, String[] s1) {
        if (s1 != null && s1.length > 0) {
            return s1;
        }
        return df;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setPageAlias(String[] pageAlias) {
        this.pageAlias = pageAlias;
    }

    public void setSizeAlias(String[] sizeAlias) {
        this.sizeAlias = sizeAlias;
    }

    public void setSortAlias(String[] sortAlias) {
        this.sortAlias = sortAlias;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public String[] getPageAlias() {
        return this.pageAlias;
    }

    public String[] getSizeAlias() {
        return this.sizeAlias;
    }

    public String[] getSortAlias() {
        return this.sortAlias;
    }
}

