/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.time.StopWatch;
import pro.fessional.wings.silencer.watch.Watches;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;

public class SlowResponseInterceptor
implements AutoRegisterInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SlowResponseInterceptor.class);
    public static final int ORDER = -9999000;
    private int order = -9999000;
    private long thresholdMillis = -1L;
    private BiConsumer<Long, HttpServletRequest> costAndReqConsumer = (c, r) -> log.warn("SLOW-RES cost={}ms, uri={}", c, (Object)r.getRequestURI());

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        if (this.thresholdMillis < 0L) {
            return true;
        }
        StopWatch.Watch watch = Watches.acquire((String)request.getRequestURI());
        request.setAttribute("WINGS.ATTR.STOP_WATCH", (Object)watch);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) {
        StopWatch.Watch watch = (StopWatch.Watch)request.getAttribute("WINGS.ATTR.STOP_WATCH");
        if (watch == null) {
            return;
        }
        watch.close();
        long cost = watch.getElapseMs();
        boolean slow = cost >= this.thresholdMillis;
        try {
            if (slow) {
                this.costAndReqConsumer.accept(cost, request);
            }
            Watches.release((boolean)true, (String)(slow ? "SlowResponseInterceptor" : null));
        }
        catch (Throwable throwable) {
            Watches.release((boolean)true, (String)(slow ? "SlowResponseInterceptor" : null));
            throw throwable;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public long getThresholdMillis() {
        return this.thresholdMillis;
    }

    public BiConsumer<Long, HttpServletRequest> getCostAndReqConsumer() {
        return this.costAndReqConsumer;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setThresholdMillis(long thresholdMillis) {
        this.thresholdMillis = thresholdMillis;
    }

    public void setCostAndReqConsumer(BiConsumer<Long, HttpServletRequest> costAndReqConsumer) {
        this.costAndReqConsumer = costAndReqConsumer;
    }
}

