/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import pro.fessional.wings.slardar.servlet.response.view.PlainTextView;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;

public abstract class WingsExceptionResolver<T extends Exception>
extends AbstractHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(WingsExceptionResolver.class);
    protected final Class<?> acceptClass;

    protected WingsExceptionResolver() {
        Type superClass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        }
        this.acceptClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
        log.info("WingsExceptionResolver={}, Exception={}", (Object)((Object)((Object)this)).getClass().getName(), this.acceptClass);
    }

    protected ModelAndView doResolveException(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, Object handler, @NotNull Exception ex) {
        if (this.acceptClass.isInstance(ex)) {
            SimpleResponse body = this.resolve(ex);
            if (body == null) {
                return null;
            }
            ModelAndView mav = new ModelAndView();
            PlainTextView pv = new PlainTextView(body.getContentType(), body.getResponseBody());
            mav.setStatus((HttpStatusCode)HttpStatus.valueOf((int)body.getHttpStatus()));
            mav.setView((View)pv);
            return mav;
        }
        return null;
    }

    protected abstract SimpleResponse resolve(T var1);
}

