/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.concur.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.cache2k.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.bits.Md5;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.concur.FirstBlood;
import pro.fessional.wings.slardar.concur.impl.FirstBloodHandler;
import pro.fessional.wings.slardar.servlet.request.RequestHelper;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;

public class FirstBloodImageHandler
implements FirstBloodHandler {
    public static final int ORDER = -29996900;
    private int order = -29996900;
    private String clientTicketKey = "Client-Ticket";
    private String questCaptchaKey = "quest-captcha-image";
    private String checkCaptchaKey = "check-captcha-image";
    private String base64CaptchaKey = "base64";
    private String base64CaptchaBody = "data:image/jpeg;base64,{base64}";
    private ModelAndView needCaptchaResponse;
    private WingsRemoteResolver wingsRemoteResolver;
    private Supplier<String> captchaSupplier = () -> RandCode.human((int)6);
    private String scenePrefix = "image";
    private boolean caseIgnore = true;

    @Override
    public boolean accept(@NotNull HttpServletRequest request, @NotNull FirstBlood anno) {
        String scene = anno.scene();
        return scene.isEmpty() || scene.startsWith(this.scenePrefix);
    }

    @Override
    public boolean handle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull HandlerMethod handler, @NotNull Cache<Object, Object> cache, @NotNull FirstBlood anno) {
        Tkn tkn;
        Key key;
        String uri = request.getRequestURI();
        String uk = this.getClientTicketKey(request);
        long now = ThreadNow.millis();
        if (uk.isEmpty()) {
            key = new Key(uri, this.makeClientTicket(request));
            tkn = (Tkn)cache.computeIfAbsent((Object)key, k -> new Tkn(now));
            this.sendClientTicket(response, key.clientCode);
        } else {
            key = new Key(uri, uk);
            tkn = (Tkn)cache.computeIfAbsent((Object)key, k -> new Tkn(now));
        }
        String ck = this.getKeyCode(request, this.questCaptchaKey);
        if (!ck.isEmpty()) {
            if (tkn.check(ck, this.caseIgnore, false)) {
                DummyBlock.empty();
            } else {
                String accept = request.getHeader("Accept");
                String fmt = this.base64CaptchaKey.isEmpty() || accept == null || !accept.contains(this.base64CaptchaKey) ? null : this.base64CaptchaBody;
                this.showCaptcha(response, tkn.fresh(anno.retry(), this.captchaSupplier), fmt);
            }
            return false;
        }
        String vk = this.getKeyCode(request, this.checkCaptchaKey);
        if (!vk.isEmpty() && tkn.check(vk, this.caseIgnore, true)) {
            return true;
        }
        int fst = anno.first();
        long rct = tkn.recent;
        if (fst > 3 && (rct == now || rct + (long)fst * 1000L < now)) {
            tkn.recent = now;
            return true;
        }
        this.needCaptcha(request, response, key.clientCode);
        return false;
    }

    protected void needCaptcha(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, String token) {
        ResponseHelper.bothHeadCookie(response, this.clientTicketKey, token, 600);
        ResponseHelper.renderModelAndView(this.needCaptchaResponse, response, request);
    }

    protected void showCaptcha(@NotNull HttpServletResponse response, String code, String fmt) {
        ResponseHelper.showCaptcha(response, code, fmt);
    }

    @NotNull
    protected String makeClientTicket(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return session.getId();
        }
        String remoteIp = this.wingsRemoteResolver == null ? request.getRemoteAddr() : this.wingsRemoteResolver.resolveRemoteIp(request);
        return Md5.sum((String)(remoteIp + ThreadNow.millis()));
    }

    protected void sendClientTicket(@NotNull HttpServletResponse response, String token) {
        ResponseHelper.bothHeadCookie(response, this.clientTicketKey, token, 600);
    }

    @NotNull
    private String getClientTicketKey(HttpServletRequest request) {
        String token = request.getHeader(this.clientTicketKey);
        if (token != null && !token.isEmpty()) {
            return token;
        }
        token = RequestHelper.getCookieValue(request, this.clientTicketKey);
        return token == null ? "" : token;
    }

    @NotNull
    private String getKeyCode(HttpServletRequest request, String key) {
        String token = request.getParameter(key);
        if (token != null) {
            return token;
        }
        token = request.getHeader(key);
        return token == null ? "" : token;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setClientTicketKey(String clientTicketKey) {
        this.clientTicketKey = clientTicketKey;
    }

    @Generated
    public void setQuestCaptchaKey(String questCaptchaKey) {
        this.questCaptchaKey = questCaptchaKey;
    }

    @Generated
    public void setCheckCaptchaKey(String checkCaptchaKey) {
        this.checkCaptchaKey = checkCaptchaKey;
    }

    @Generated
    public void setBase64CaptchaKey(String base64CaptchaKey) {
        this.base64CaptchaKey = base64CaptchaKey;
    }

    @Generated
    public void setBase64CaptchaBody(String base64CaptchaBody) {
        this.base64CaptchaBody = base64CaptchaBody;
    }

    @Generated
    public void setNeedCaptchaResponse(ModelAndView needCaptchaResponse) {
        this.needCaptchaResponse = needCaptchaResponse;
    }

    @Generated
    public void setWingsRemoteResolver(WingsRemoteResolver wingsRemoteResolver) {
        this.wingsRemoteResolver = wingsRemoteResolver;
    }

    @Generated
    public void setCaptchaSupplier(Supplier<String> captchaSupplier) {
        this.captchaSupplier = captchaSupplier;
    }

    @Generated
    public void setScenePrefix(String scenePrefix) {
        this.scenePrefix = scenePrefix;
    }

    @Generated
    public void setCaseIgnore(boolean caseIgnore) {
        this.caseIgnore = caseIgnore;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getClientTicketKey() {
        return this.clientTicketKey;
    }

    @Generated
    public String getQuestCaptchaKey() {
        return this.questCaptchaKey;
    }

    @Generated
    public String getCheckCaptchaKey() {
        return this.checkCaptchaKey;
    }

    @Generated
    public String getBase64CaptchaKey() {
        return this.base64CaptchaKey;
    }

    @Generated
    public String getBase64CaptchaBody() {
        return this.base64CaptchaBody;
    }

    @Generated
    public ModelAndView getNeedCaptchaResponse() {
        return this.needCaptchaResponse;
    }

    @Generated
    public WingsRemoteResolver getWingsRemoteResolver() {
        return this.wingsRemoteResolver;
    }

    @Generated
    public Supplier<String> getCaptchaSupplier() {
        return this.captchaSupplier;
    }

    @Generated
    public String getScenePrefix() {
        return this.scenePrefix;
    }

    @Generated
    public boolean isCaseIgnore() {
        return this.caseIgnore;
    }

    public static class Key {
        public final String requestUri;
        public final String clientCode;

        @Generated
        public Key(String requestUri, String clientCode) {
            this.requestUri = requestUri;
            this.clientCode = clientCode;
        }

        @Generated
        public String getRequestUri() {
            return this.requestUri;
        }

        @Generated
        public String getClientCode() {
            return this.clientCode;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestUri = this.getRequestUri();
            String other$requestUri = other.getRequestUri();
            if (this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri)) {
                return false;
            }
            String this$clientCode = this.getClientCode();
            String other$clientCode = other.getClientCode();
            return !(this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestUri = this.getRequestUri();
            result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
            String $clientCode = this.getClientCode();
            result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "FirstBloodImageHandler.Key(requestUri=" + this.getRequestUri() + ", clientCode=" + this.getClientCode() + ")";
        }
    }

    public static class Tkn {
        private volatile long recent;
        private final AtomicInteger retry = new AtomicInteger(0);
        private volatile String token = "";

        public Tkn(long now) {
            this.recent = now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean check(String tkn, boolean ci, boolean once) {
            boolean eq;
            AtomicInteger atomicInteger = this.retry;
            synchronized (atomicInteger) {
                boolean bl = eq = ci ? tkn.equalsIgnoreCase(this.token) : tkn.equals(this.token);
                if (eq) {
                    if (once) {
                        this.retry.set(0);
                        this.token = "";
                    }
                } else {
                    this.retry.decrementAndGet();
                }
            }
            return eq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String fresh(int max, Supplier<String> supplier) {
            String code = supplier.get();
            AtomicInteger atomicInteger = this.retry;
            synchronized (atomicInteger) {
                if (this.retry.get() <= 0) {
                    this.retry.set(max);
                }
                this.token = code;
            }
            return code;
        }
    }
}

