/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor.viewer;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.cache2k.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.id.Ulid;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.monitor.WarnFilter;
import pro.fessional.wings.slardar.monitor.WarnMetric;
import pro.fessional.wings.slardar.monitor.viewer.LogConf;
import pro.fessional.wings.slardar.spring.prop.SlardarMonitorProp;

@RestController
@ConditionalWingsEnabled(abs="wings.slardar.monitor.view.enable")
public class LogViewer
implements WarnFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogViewer.class);
    private final LogConf conf;
    private final Cache<String, String> cache;

    @Autowired
    public LogViewer(SlardarMonitorProp prop) {
        this(prop.getView());
    }

    public LogViewer(LogConf conf) {
        this.conf = conf;
        this.cache = WingsCache2k.builder(LogViewer.class, (String)"cache", (int)2000, (Duration)conf.getAlive(), null, String.class, String.class).build();
    }

    @Operation(summary="Alarm logs can be viewed in conjunction with alarm notifications when self-monitoring is enabled.", description="# Usage\nPass the log id to view the log.\n## Params\n* @param id - log id, max 2k caches in 36H\n## Returns\n* @return {200 | string} log context or empty")
    @GetMapping(value={"${wings.slardar.monitor.view.mapping}"})
    public void view(@RequestParam(value="id") String id, HttpServletResponse res) throws IOException {
        if (id == null) {
            return;
        }
        String log = (String)this.cache.get((Object)id);
        if (log == null) {
            return;
        }
        File file = new File(log);
        if (!file.canRead()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            long len = this.conf.getLength().toBytes();
            ServletOutputStream outputStream = res.getOutputStream();
            IOUtils.copyLarge((InputStream)fis, (OutputStream)res.getOutputStream(), (long)0L, (long)len);
            if (file.length() - len > 0L) {
                String more = String.format("\n\n...... %,d / %,d bytes", len, file.length());
                outputStream.write(more.getBytes());
            }
        }
    }

    public void filter(Map<String, List<WarnMetric.Warn>> warns) {
        ArrayList<WarnMetric.Warn> flt = new ArrayList<WarnMetric.Warn>();
        for (List<WarnMetric.Warn> list : warns.values()) {
            Iterator<WarnMetric.Warn> iter = list.iterator();
            while (iter.hasNext()) {
                WarnMetric.Warn next = iter.next();
                if (next.getType() != WarnMetric.Type.File) continue;
                if (this.canIgnoreHead(next.getWarn())) {
                    log.debug("remove ignored warning");
                    iter.remove();
                    continue;
                }
                WarnMetric.Warn wd = new WarnMetric.Warn();
                wd.setType(WarnMetric.Type.Link);
                wd.setKey(next.getKey());
                wd.setRule(next.getRule());
                String id = Ulid.next();
                this.cache.put((Object)id, (Object)next.getWarn());
                wd.setWarn(this.conf.getDomain() + this.conf.getMapping() + "?id=" + id);
                flt.add(wd);
            }
        }
        warns.entrySet().removeIf(it -> ((List)it.getValue()).isEmpty());
        if (!flt.isEmpty()) {
            List<WarnMetric.Warn> old = warns.get("wings.slardar.monitor.view");
            if (old == null) {
                warns.put("wings.slardar.monitor.view", flt);
            } else {
                old.addAll(flt);
            }
        }
    }

    private boolean canIgnoreHead(String out) {
        boolean bl;
        if (this.conf.getIgnore().isEmpty()) {
            return false;
        }
        long max = this.conf.getLength().toBytes();
        File file = new File(out);
        if (file.length() > max || !file.canRead()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            Collection ign = this.conf.getIgnore().values();
            int tol = 0;
            int cnt = 0;
            block7: while ((line = reader.readLine()) != null && max > 0L) {
                if (line.isEmpty()) continue;
                max -= (long)line.length();
                ++tol;
                for (String s : ign) {
                    if (!line.contains(s)) continue;
                    ++cnt;
                    continue block7;
                }
            }
            bl = tol == cnt;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    @Generated
    public LogConf getConf() {
        return this.conf;
    }
}

