/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.context.TerminalSecurityAttribute;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;

public class WingsAuthenticationEventPublisher
extends DefaultAuthenticationEventPublisher {
    public WingsAuthenticationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAuthenticationSuccess(Authentication authentication) {
        boolean terminal = false;
        Object object = authentication.getPrincipal();
        if (object instanceof WingsUserDetails) {
            WingsUserDetails userDetails = (WingsUserDetails)object;
            object = authentication.getDetails();
            if (object instanceof WingsAuthDetails) {
                WingsAuthDetails authDetails = (WingsAuthDetails)object;
                Map<String, String> meta = authDetails.getMetaData();
                TerminalContext.Builder builder = new TerminalContext.Builder().locale(userDetails.getLocale()).timeZone(userDetails.getZoneId()).terminal(TerminalAttribute.TerminalAddr, (Object)meta.get("AuthAddr")).terminal(TerminalAttribute.TerminalAgent, (Object)meta.get("AuthAgent")).user(userDetails.getUserId()).authType(userDetails.getAuthType()).username(userDetails.getUsername()).authPerm((Collection)userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet())).terminal(TerminalSecurityAttribute.UserDetails, (Object)userDetails).terminal(TerminalSecurityAttribute.AuthDetails, (Object)authDetails);
                TerminalContext.login((TerminalContext.Context)builder.build());
                terminal = true;
            }
        }
        try {
            super.publishAuthenticationSuccess(authentication);
        }
        finally {
            if (terminal) {
                TerminalContext.logout((boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
        boolean terminal = false;
        if (authentication instanceof WingsBindAuthToken) {
            WingsBindAuthToken authToken = (WingsBindAuthToken)authentication;
            Object object = authentication.getDetails();
            if (object instanceof WingsAuthDetails) {
                WingsAuthDetails authDetails = (WingsAuthDetails)object;
                Map<String, String> meta = authDetails.getMetaData();
                TerminalContext.Builder builder = new TerminalContext.Builder().locale(LocaleContextHolder.getLocale()).timeZone(LocaleContextHolder.getTimeZone()).terminal(TerminalAttribute.TerminalAddr, (Object)meta.get("AuthAddr")).terminal(TerminalAttribute.TerminalAgent, (Object)meta.get("AuthAgent")).authType(authToken.getAuthType()).username(authToken.getName()).terminal(TerminalSecurityAttribute.AuthDetails, (Object)authDetails).guest();
                TerminalContext.login((TerminalContext.Context)builder.build());
                terminal = true;
            }
        }
        try {
            super.publishAuthenticationFailure(exception, authentication);
        }
        finally {
            if (terminal) {
                TerminalContext.logout((boolean)false);
            }
        }
    }
}

