/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.stream;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.io.CircleInputStream;

public class CircleServletInputStream
extends ServletInputStream {
    private final ServletInputStream backend;
    private final CircleInputStream circled;

    public CircleServletInputStream(ServletInputStream backend) {
        this.backend = backend;
        this.circled = new CircleInputStream((InputStream)backend);
    }

    public CircleServletInputStream(ServletInputStream backend, ByteArrayOutputStream content) {
        this.backend = backend;
        this.circled = new CircleInputStream(content);
    }

    public int read() throws IOException {
        return this.circled.read();
    }

    public int read(byte @NotNull [] b) throws IOException {
        return this.circled.read(b);
    }

    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        return this.circled.read(b, off, len);
    }

    public boolean isFinished() {
        return this.circled.isFinished();
    }

    public boolean isReady() {
        try {
            return this.circled.available() > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setReadListener(ReadListener readListener) {
        this.backend.setReadListener(readListener);
    }
}

